<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
require_once 'config/koneksi.php';
?>

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tentang Kami - Plantify</title>
    <?php include 'includes/tailwind.php'; ?>
</head>

<body class="bg-slate-50 text-slate-700">

    <?php include 'includes/navbar.php'; ?>

    <!-- HERO -->
    <section class="relative bg-emerald-900 text-white py-28 overflow-hidden mt-15">
        <div class="container mx-auto px-4 text-center relative z-10">
            <span
                class="inline-block py-1 px-3 rounded-full bg-emerald-800 text-emerald-200 text-sm font-semibold mb-4 border border-emerald-700"
                data-aos="fade-down">
                About Plantify
            </span>
            <h1 class="text-4xl md:text-6xl font-extrabold mb-6" data-aos="fade-up">
                Tentang <span class="text-emerald-400">Plantify</span>
            </h1>
            <p class="max-w-2xl mx-auto text-lg text-emerald-100" data-aos="fade-up" data-aos-delay="100">
                Plantify hadir untuk membantu siapa saja merawat dan memiliki tanaman dengan mudah,
                menyenangkan, dan berkelanjutan.
            </p>
        </div>
    </section>

    <!-- ABOUT -->
    <section class="py-20">
        <div class="container mx-auto px-4 grid lg:grid-cols-2 gap-12 items-center">
            <div data-aos="fade-right">
                <h2 class="text-3xl font-bold text-slate-900 mb-4">Siapa Kami?</h2>
                <p class="text-slate-600 leading-relaxed mb-4">
                    <strong>Plantify</strong> adalah platform penjualan tanaman hias dan kebutuhan berkebun
                    yang bertujuan untuk mendukung gaya hidup hijau dan ramah lingkungan.
                </p>
                <p class="text-slate-600 leading-relaxed">
                    Kami percaya bahwa merawat tanaman bukan hanya soal estetika, tetapi juga
                    tentang menjaga keseimbangan alam dan kualitas hidup.
                </p>
            </div>

            <div class="rounded-3xl overflow-hidden shadow-xl" data-aos="fade-left">
                <img src="https://images.unsplash.com/photo-1492496913980-501348b61469" alt="Tentang Plantify"
                    class="w-full h-[500px] object-cover">
            </div>
        </div>
    </section>

    <!-- VISI MISI -->
    <section class="bg-white py-20">
        <div class="container mx-auto px-4">
            <div class="text-center mb-14" data-aos="fade-up">
                <h2 class="text-3xl font-bold text-slate-900">Visi & Misi</h2>
                <div class="h-1 w-20 bg-emerald-500 mx-auto mt-3 rounded-full"></div>
            </div>

            <div class="grid md:grid-cols-2 gap-8">
                <div class="bg-slate-50 p-8 rounded-2xl shadow" data-aos="fade-up">
                    <h3 class="text-xl font-bold text-emerald-600 mb-3">Visi</h3>
                    <p class="text-slate-600 leading-relaxed">
                        Menjadi platform tanaman terpercaya yang menginspirasi masyarakat
                        untuk mencintai dan merawat tanaman secara berkelanjutan.
                    </p>
                </div>

                <div class="bg-slate-50 p-8 rounded-2xl shadow" data-aos="fade-up" data-aos-delay="100">
                    <h3 class="text-xl font-bold text-emerald-600 mb-3">Misi</h3>
                    <ul class="list-disc list-inside text-slate-600 space-y-2">
                        <li>Menyediakan tanaman berkualitas dan sehat</li>
                        <li>Memberikan edukasi perawatan tanaman</li>
                        <li>Mendukung gaya hidup hijau</li>
                        <li>Memberikan pelayanan terbaik kepada pelanggan</li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    <!-- KEUNGGULAN -->
    <section class="py-20">
        <div class="container mx-auto px-4">
            <div class="text-center mb-14" data-aos="fade-up">
                <h2 class="text-3xl font-bold text-slate-900">Kenapa Memilih Plantify?</h2>
            </div>

            <div class="grid sm:grid-cols-2 lg:grid-cols-4 gap-8">
                <div class="bg-white p-6 rounded-2xl shadow text-center" data-aos="zoom-in">
                    <i class="fas fa-seedling text-3xl text-emerald-500 mb-4"></i>
                    <h4 class="font-bold mb-2">Tanaman Sehat</h4>
                    <p class="text-sm text-slate-500">Tanaman terkurasi dan siap tumbuh</p>
                </div>

                <div class="bg-white p-6 rounded-2xl shadow text-center" data-aos="zoom-in" data-aos-delay="100">
                    <i class="fas fa-box-open text-3xl text-emerald-500 mb-4"></i>
                    <h4 class="font-bold mb-2">Packing Aman</h4>
                    <p class="text-sm text-slate-500">Dikirim dengan perlindungan maksimal</p>
                </div>

                <div class="bg-white p-6 rounded-2xl shadow text-center" data-aos="zoom-in" data-aos-delay="200">
                    <i class="fas fa-book text-3xl text-emerald-500 mb-4"></i>
                    <h4 class="font-bold mb-2">Panduan Lengkap</h4>
                    <p class="text-sm text-slate-500">Cocok untuk pemula</p>
                </div>

                <div class="bg-white p-6 rounded-2xl shadow text-center" data-aos="zoom-in" data-aos-delay="300">
                    <i class="fas fa-headset text-3xl text-emerald-500 mb-4"></i>
                    <h4 class="font-bold mb-2">Support Responsif</h4>
                    <p class="text-sm text-slate-500">Siap membantu kapan saja</p>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA -->
    <section class="bg-emerald-600 py-20 text-white text-center">
        <div class="container mx-auto px-4" data-aos="fade-up">
            <h2 class="text-3xl font-bold mb-4">Mari Hijaukan Ruangmu Bersama Plantify</h2>
            <p class="mb-8 text-emerald-100">
                Temukan tanaman favoritmu dan mulai perjalanan hijau hari ini.
            </p>
            <a href="produk.php"
                class="inline-block bg-white text-emerald-600 font-bold px-8 py-4 rounded-full hover:bg-emerald-100 transition">
                Lihat Produk
            </a>
        </div>
    </section>

    <?php include 'includes/footer.php'; ?>

</body>

</html>