<?php
session_start();
require_once 'config/koneksi.php';
require_once 'config/cart.php';

$db = new Koneksi();
$conn = $db->getConnection();

// --- Logika Filter & Search ---
$filter_kategori = isset($_GET['kategori']) ? $_GET['kategori'] : '';
$keyword = isset($_GET['keyword']) ? $_GET['keyword'] : '';

// PERBAIKAN: Tambahkan kondisi p.is_deleted = 0 untuk tidak menampilkan produk yang dihapus
$sql = "SELECT p.*, k.nama_kategori FROM produk p 
        JOIN kategori k ON p.id_kategori = k.id_kategori 
        WHERE p.is_deleted = 0";
$params = [];
$types = "";

// Filter Kategori
if (!empty($filter_kategori)) {
    $sql .= " AND p.id_kategori = ?";
    $params[] = $filter_kategori;
    $types .= "i";
}

// Filter Search Keyword
if (!empty($keyword)) {
    $sql .= " AND (p.nama_produk LIKE ? OR k.nama_kategori LIKE ?)";
    $search_param = "%" . $keyword . "%";
    $params[] = $search_param;
    $params[] = $search_param;
    $types .= "ss";
}

$sql .= " ORDER BY p.id_produk DESC";

$stmt = $conn->prepare($sql);
if (!empty($params)) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$all_products = $stmt->get_result();

// Ambil data kategori untuk filter
$kategori_result = $conn->query("SELECT * FROM kategori");
?>


<head>
    <title>Katalog Produk - Plantify</title>

    <?php include 'includes/tailwind.php'; ?>

    <link rel="stylesheet" href="assets/css/produk.css">k
</head>

<body class="bg-slate-50 text-slate-800 font-sans antialiased">

    <?php include 'includes/navbar.php'; ?>

    <header class="relative bg-emerald-900 text-white pt-32 pb-20 md:pt-40 md:pb-24 overflow-hidden">
        <div class="absolute inset-0 opacity-10">
            <svg class="h-full w-full" viewBox="0 0 100 100" preserveAspectRatio="none">
                <path d="M0 100 C 20 0 50 0 100 100 Z" fill="white" />
            </svg>
        </div>

        <div class="container mx-auto px-6 relative z-10 text-center" data-aos="fade-down" data-aos-duration="1000">
            <span
                class="inline-block py-1 px-3 rounded-full bg-emerald-800 text-emerald-200 text-sm font-semibold mb-4 border border-emerald-700"
                data-aos="fade-down">
                Plantify Product
            </span>
            <h1 class="text-4xl md:text-6xl font-extrabold tracking-tight mb-4">
                Temukan <span class="text-emerald-400">Tanaman</span> Impianmu
            </h1>
            <p class="text-emerald-100 text-lg md:text-xl max-w-2xl mx-auto font-light">
                Hadirkan kesegaran alami di setiap sudut ruangan dengan koleksi tanaman hias terbaik kami.
            </p>
        </div>
    </header>

    <main class="container mx-auto px-4 mt-10 relative z-20 mb-20">

        <div class="bg-white rounded-2xl shadow-xl border border-gray-100 p-4 md:p-6 mb-12" data-aos="fade-up"
            data-aos-delay="100">
            <div class="flex flex-col md:flex-row gap-4 items-center justify-between">

                <form action="produk.php" method="GET" class="w-full md:w-auto flex-shrink-0">
                    <?php if(!empty($keyword)): ?>
                    <input type="hidden" name="keyword" value="<?php echo htmlspecialchars($keyword); ?>">
                    <?php endif; ?>

                    <div class="relative group">
                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                            <i
                                class="fas fa-filter text-emerald-500 group-hover:text-emerald-600 transition-colors"></i>
                        </div>
                        <select name="kategori" onchange="this.form.submit()"
                            class="appearance-none w-full md:w-64 bg-slate-50 border border-slate-200 text-slate-700 py-3 pl-10 pr-10 rounded-xl leading-tight focus:outline-none focus:bg-white focus:ring-2 focus:ring-emerald-500 focus:border-transparent cursor-pointer transition-all font-medium hover:bg-slate-100">
                            <option value="">Semua Kategori</option>
                            <?php 
                            $kategori_result->data_seek(0);
                            while($cat = $kategori_result->fetch_assoc()): 
                            ?>
                            <option value="<?php echo $cat['id_kategori']; ?>"
                                <?php if ($filter_kategori == $cat['id_kategori']) echo 'selected'; ?>>
                                <?php echo htmlspecialchars($cat['nama_kategori']); ?>
                            </option>
                            <?php endwhile; ?>
                        </select>
                        <div
                            class="pointer-events-none absolute inset-y-0 right-0 flex items-center px-3 text-slate-500">
                            <i class="fas fa-chevron-down text-xs"></i>
                        </div>
                    </div>
                </form>

                <form action="produk.php" method="GET" class="w-full md:flex-1 md:max-w-lg">
                    <?php if(!empty($filter_kategori)): ?>
                    <input type="hidden" name="kategori" value="<?php echo htmlspecialchars($filter_kategori); ?>">
                    <?php endif; ?>

                    <div class="relative group">
                        <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                            <i
                                class="fas fa-search text-slate-400 group-focus-within:text-emerald-500 transition-colors"></i>
                        </div>
                        <input type="text" name="keyword" value="<?php echo htmlspecialchars($keyword); ?>"
                            placeholder="Cari nama tanaman (e.g., Monstera)..."
                            class="w-full bg-slate-50 border border-slate-200 text-slate-800 rounded-xl py-3 pl-12 pr-4 focus:outline-none focus:bg-white focus:ring-2 focus:ring-emerald-500 focus:border-transparent transition-all placeholder-slate-400">
                    </div>
                </form>
            </div>

            <?php if(!empty($keyword) || !empty($filter_kategori)): ?>
            <div class="mt-4 flex items-center gap-2 text-sm text-slate-500 animate-fade-in-down">
                <span>Menampilkan hasil untuk:</span>
                <?php if(!empty($keyword)): ?>
                <span class="bg-emerald-100 text-emerald-700 px-3 py-1 rounded-full font-medium">
                    "<?php echo htmlspecialchars($keyword); ?>"
                </span>
                <?php endif; ?>
                <?php if(!empty($filter_kategori)): ?>
                <span class="bg-emerald-100 text-emerald-700 px-3 py-1 rounded-full font-medium">
                    Kategori Terpilih
                </span>
                <?php endif; ?>
                <a href="produk.php"
                    class="ml-auto text-red-500 hover:text-red-700 font-medium hover:underline transition">
                    <i class="fas fa-times-circle mr-1"></i> Reset Filter
                </a>
            </div>
            <?php endif; ?>
        </div>

        <?php if ($all_products->num_rows > 0): ?>
        <div class="grid grid-cols-2 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-8">
            <?php 
                $delay = 0;
                while($product = $all_products->fetch_assoc()): 
                    $delay += 50; // Stagger effect
                ?>
            <div class="group bg-white rounded-2xl border border-slate-100 shadow-sm hover:shadow-2xl hover:-translate-y-2 transition-all duration-300 overflow-hidden flex flex-col h-full relative"
                data-aos="fade-up" data-aos-delay="<?php echo $delay; ?>" data-aos-offset="100">

                <div class="relative h-72 overflow-hidden bg-slate-100">
                    <span
                        class="absolute top-4 left-4 z-10 bg-white/90 backdrop-blur-sm text-emerald-800 text-xs font-bold uppercase tracking-wider px-3 py-1.5 rounded-lg shadow-sm">
                        <?php echo htmlspecialchars($product['nama_kategori']); ?>
                    </span>

                    <a href="detail.php?id=<?php echo $product['id_produk']; ?>" class="block h-full w-full">
                        <img src="/Plantify/uploads/produk/<?php echo htmlspecialchars($product['gambar']); ?>"
                            alt="<?php echo htmlspecialchars($product['nama_produk']); ?>"
                            class="w-full h-full object-cover transform group-hover:scale-110 transition-transform duration-700 ease-in-out"
                            onerror="this.src='https://via.placeholder.com/400x400?text=Plantify+Image'">
                    </a>

                    <div
                        class="absolute inset-0 bg-black/20 opacity-0 group-hover:opacity-100 transition-opacity duration-300 flex items-center justify-center">
                        <a href="detail.php?id=<?php echo $product['id_produk']; ?>"
                            class="transform translate-y-4 group-hover:translate-y-0 transition-transform duration-300 bg-white text-emerald-900 px-6 py-2 rounded-full font-bold shadow-lg hover:bg-emerald-500 hover:text-white">
                            Lihat Detail
                        </a>
                    </div>
                </div>

                <div class="p-5 flex flex-col flex-grow">
                    <h3
                        class="text-lg font-bold text-slate-900 mb-1 line-clamp-1 hover:text-emerald-600 transition-colors">
                        <a href="detail.php?id=<?php echo $product['id_produk']; ?>">
                            <?php echo htmlspecialchars($product['nama_produk']); ?>
                        </a>
                    </h3>

                    <div class="flex items-center mb-4">
                        <div class="flex text-yellow-400 text-xs">
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star-half-alt"></i>
                        </div>
                        <span class="text-xs text-slate-400 ml-2">(Review)</span>
                    </div>

                    <div class="mt-auto flex items-center justify-between pt-4 border-t border-slate-50">
                        <div class="flex flex-col">
                            <span class="text-xs text-slate-400 uppercase font-semibold">Harga</span>
                            <span class="text-xl font-semibold ">
                                Rp <?php echo number_format($product['harga'], 0, ',', '.'); ?>
                            </span>
                        </div>
                        <a href="detail.php?id=<?php echo $product['id_produk']; ?>"
                            class="w-10 h-10 rounded-full bg-slate-50 text-slate-600 flex items-center justify-center hover:bg-emerald-600 hover:text-white transition-all duration-300 shadow-sm">
                            <i
                                class="fas fa-arrow-right transform -rotate-45 group-hover:rotate-0 transition-transform duration-300"></i>
                        </a>
                    </div>
                </div>
            </div>
            <?php endwhile; ?>
        </div>
        <?php else: ?>
        <div class="flex flex-col items-center justify-center py-24 px-4 bg-white rounded-3xl border border-dashed border-slate-300 text-center"
            data-aos="zoom-in">
            <div class="bg-emerald-50 p-6 rounded-full mb-6">
                <i class="fas fa-leaf text-5xl text-emerald-300"></i>
            </div>
            <h3 class="text-2xl font-bold text-slate-900 mb-2">Produk Tidak Ditemukan</h3>
            <p class="text-slate-500 max-w-md mx-auto mb-8">
                <?php if(!empty($keyword)): ?>
                Maaf, kami tidak dapat menemukan tanaman dengan kata kunci
                "<strong><?php echo htmlspecialchars($keyword); ?></strong>". Coba kata kunci lain atau reset filter.
                <?php else: ?>
                Maaf, tidak ada produk yang tersedia saat ini.
                <?php endif; ?>
            </p>
            <a href="produk.php"
                class="inline-flex items-center px-8 py-3 bg-emerald-600 hover:bg-emerald-700 text-white font-medium rounded-xl transition shadow-lg shadow-emerald-200">
                <i class="fas fa-redo-alt mr-2"></i> Reset Pencarian
            </a>
        </div>
        <?php endif; ?>

    </main>

    <?php include 'includes/footer.php' ?>
</body>

</html>