<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once 'config/koneksi.php';
require_once 'config/cart.php'; // Tambahkan ini untuk navbar

// Cek apakah user sudah login
if (!isset($_SESSION['id_user'])) {
    header('Location: auth/login.php');
    exit;
}

$db = new Koneksi();
$conn = $db->getConnection();
$id_user = $_SESSION['id_user'];

// Ambil semua transaksi user
$sql = "SELECT * FROM transaksi WHERE id_user = ? ORDER BY tanggal_pesan DESC";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id_user);
$stmt->execute();
$transaksi = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);

// Function untuk mendapatkan detail produk
function getDetailProduk($conn, $id_transaksi) {
    $sql = "SELECT dt.*, p.nama_produk, p.gambar 
            FROM detail_transaksi dt 
            JOIN produk p ON dt.id_produk = p.id_produk 
            WHERE dt.id_transaksi = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id_transaksi);
    $stmt->execute();
    return $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
}

// Function untuk badge status
function getStatusBadge($status) {
    $badges = [
        'menunggu' => '<span class="px-3 py-1 text-xs font-semibold rounded-full bg-yellow-100 text-yellow-800">Menunggu Konfirmasi</span>',
        'diproses' => '<span class="px-3 py-1 text-xs font-semibold rounded-full bg-blue-100 text-blue-800">Sedang Diproses</span>',
        'selesai' => '<span class="px-3 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">Selesai</span>',
        'dibatalkan' => '<span class="px-3 py-1 text-xs font-semibold rounded-full bg-red-100 text-red-800">Dibatalkan</span>'
    ];
    return $badges[$status] ?? $status;
}
?>
<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pesanan Saya - Plantify</title>
    <?php include 'includes/tailwind.php'; ?>
</head>

<body class="bg-gray-50">
    <?php include 'includes/navbar.php'; ?>

    <div class="container mx-auto px-4 py-8">
        <h1 class="text-3xl font-bold mb-6">Pesanan Saya</h1>

        <!-- Success Message -->
        <?php if (isset($_SESSION['success_message'])): ?>
        <div
            class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-6 flex justify-between items-center">
            <span><?= htmlspecialchars($_SESSION['success_message']) ?></span>
            <button onclick="this.parentElement.remove()" class="text-green-700 hover:text-green-900">
                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd"
                        d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                        clip-rule="evenodd"></path>
                </svg>
            </button>
        </div>
        <?php unset($_SESSION['success_message']); ?>
        <?php endif; ?>

        <?php if (empty($transaksi)): ?>
        <div class="bg-white p-8 rounded-lg shadow text-center">
            <svg class="w-24 h-24 mx-auto text-gray-300 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                    d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                </path>
            </svg>
            <p class="text-xl font-semibold text-gray-700 mb-2">Belum Ada Pesanan</p>
            <p class="text-gray-500 mb-6">Anda belum melakukan pemesanan</p>
            <a href="index.php"
                class="inline-block bg-blue-600 text-white px-6 py-3 rounded-lg hover:bg-blue-700 transition">
                Mulai Belanja
            </a>
        </div>
        <?php else: ?>
        <div class="space-y-4">
            <?php foreach ($transaksi as $t): ?>
            <?php $detail_produk = getDetailProduk($conn, $t['id_transaksi']); ?>

            <div class="bg-white rounded-lg shadow overflow-hidden">
                <!-- Header Pesanan -->
                <div class="bg-gray-50 px-6 py-4 flex justify-between items-center border-b">
                    <div>
                        <p class="text-sm text-gray-600">Nomor Pesanan</p>
                        <p class="font-bold">#<?= str_pad($t['id_transaksi'], 8, '0', STR_PAD_LEFT) ?></p>
                        <p class="text-sm text-gray-500 mt-1">
                            <?= date('d F Y, H:i', strtotime($t['tanggal_pesan'])) ?>
                        </p>
                    </div>
                    <div class="text-right">
                        <?= getStatusBadge($t['status_pesanan']) ?>
                    </div>
                </div>

                <!-- Produk -->
                <div class="p-6">
                    <div class="space-y-4">
                        <?php foreach ($detail_produk as $dp): ?>
                        <div class="flex items-center gap-4">
                            <div class="w-16 h-16 bg-gray-100 rounded flex-shrink-0">
                                <?php if (!empty($dp['gambar'])): ?>
                                <img src="uploads/produk/<?= htmlspecialchars($dp['gambar']) ?>"
                                    alt="<?= htmlspecialchars($dp['nama_produk']) ?>"
                                    class="w-full h-full object-cover rounded">
                                <?php endif; ?>
                            </div>

                            <div class="flex-grow">
                                <h3 class="font-semibold text-gray-800"><?= htmlspecialchars($dp['nama_produk']) ?></h3>
                                <p class="text-sm text-gray-500">
                                    <?= $dp['jumlah_produk'] ?> x Rp
                                    <?= number_format($dp['harga_saat_transaksi'], 0, ',', '.') ?>
                                </p>
                            </div>

                            <div class="text-right">
                                <p class="font-bold text-gray-800">
                                    Rp
                                    <?= number_format($dp['harga_saat_transaksi'] * $dp['jumlah_produk'], 0, ',', '.') ?>
                                </p>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>

                    <!-- Info Pengiriman -->
                    <div class="mt-6 pt-6 border-t">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <p class="text-sm text-gray-600 mb-1">Nama Pemesan</p>
                                <p class="font-semibold"><?= htmlspecialchars($t['nama_pemesan']) ?></p>
                            </div>
                            <div>
                                <p class="text-sm text-gray-600 mb-1">Email</p>
                                <p class="font-semibold"><?= htmlspecialchars($t['email_pemesan']) ?></p>
                            </div>
                            <div class="md:col-span-2">
                                <p class="text-sm text-gray-600 mb-1">Alamat Pengiriman</p>
                                <p class="font-semibold"><?= htmlspecialchars($t['alamat_pemesan']) ?></p>
                            </div>
                        </div>
                    </div>

                    <!-- Total -->
                    <div class="mt-6 pt-6 border-t flex justify-between items-center">
                        <p class="text-lg font-semibold">Total Pembayaran</p>
                        <p class="text-2xl font-bold text-blue-600">
                            Rp <?= number_format($t['total_harga'], 0, ',', '.') ?>
                        </p>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
    </div>

</body>

</html>