<?php
require_once 'config/koneksi.php';
require_once 'config/cart.php'; 

$db = new Koneksi();
$conn = $db->getConnection();

// Query Produk Unggulan (Limit 8)
$featured_products = $conn->query("SELECT p.*, k.nama_kategori FROM produk p 
        JOIN kategori k ON p.id_kategori = k.id_kategori 
        WHERE p.is_deleted = 0 LIMIT 8");

// Query Kategori (Untuk section kategori)
$categories = $conn->query("SELECT * FROM kategori LIMIT 4");
?>



<?php include 'includes/tailwind.php'; ?>
<title>Plantify - Temukan Kehijauan di Rumahmu</title>


<link rel="stylesheet" href="assets/css/index.css">
<?php include 'includes/navbar.php'; ?>

<body class="font-sans antialiased text-gray-800 bg-white mt-10">

    <div class="bg-[#C1E1C1]/30 py-12 md:py-20 overflow-hidden relative">
        <div class="container mx-auto px-4 relative z-10">
            <div class="flex flex-col-reverse md:flex-row items-center justify-between gap-10">

                <div class="w-full md:w-1/2 space-y-6" data-aos="fade-right">
                    <div
                        class="inline-block px-4 py-2 bg-white rounded-full text-green-800 text-sm font-bold shadow-sm mb-2">
                        🌿 Tanaman Hias Terbaik #1
                    </div>
                    <h1 class="text-5xl md:text-7xl font-extrabold text-gray-900 leading-tight">
                        Buy your <br> <span class="text-green-700">dream plants</span>
                    </h1>
                    <div class="flex items-center gap-6 text-gray-600 font-medium">
                        <div>
                            <span class="block text-2xl font-bold text-gray-900">50+</span>
                            <span class="text-sm">Spesies</span>
                        </div>
                        <div class="h-8 w-px bg-gray-300"></div>
                        <div>
                            <span class="block text-2xl font-bold text-gray-900">100+</span>
                            <span class="text-sm">Customers</span>
                        </div>
                    </div>

                    <div class="flex flex-wrap gap-4 pt-4">
                        <form action="produk.php" method="GET"
                            class="flex w-full max-w-md bg-white p-2 rounded-full shadow-lg">
                            <input type="text" name="keyword" placeholder="Cari tanaman apa?..."
                                class="flex-grow px-4 py-2 rounded-l-full focus:outline-none text-gray-700">
                            <button type="submit"
                                class="bg-gray-900 text-white px-6 py-2 rounded-full hover:bg-green-700 transition duration-300">
                                <i class="fas fa-search"></i>
                            </button>
                        </form>
                    </div>
                </div>

                <div class="w-full md:w-1/2 flex justify-center relative" data-aos="fade-left">
                    <div
                        class="absolute top-0 right-0 w-64 h-64 bg-green-200 rounded-full mix-blend-multiply filter blur-3xl opacity-70 animate-blob">
                    </div>
                    <div
                        class="absolute -bottom-8 left-0 w-64 h-64 bg-teal-200 rounded-full mix-blend-multiply filter blur-3xl opacity-70 animate-blob animation-delay-2000">
                    </div>

                    <div
                        class="relative z-10 bg-gray-900 rounded-[3rem] p-2 md:p-0 overflow-hidden shadow-2xl transform rotate-5 hover:rotate-0 transition duration-500">
                        <img src="assets/images/hero.jpeg" alt="Plant Hero"
                            class="w-full h-[400px] md:h-[500px] object-cover rounded-[2.5rem]">
                    </div>
                    <div
                        class="relative z-10 bg-gray-900 rounded-[3rem] p-2 md:p-0 overflow-hidden shadow-2xl transform -rotate-10 hover:rotate-0 transition duration-500">
                        <img src="assets/images/hero2.jpeg" alt="Plant Hero"
                            class="w-full h-[400px] md:h-[500px] object-cover rounded-[2.5rem]">
                    </div>
                    <div class="absolute top-10 right-10 hidden md:block text-gray-800 text-4xl transform rotate-12">
                        ⤹
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="py-16 bg-white">
        <div class="container mx-auto px-4">
            <div class="text-center mb-12">
                <h2 class="text-3xl font-bold text-gray-900">Kenapa Memilih Kami?</h2>
                <p class="text-gray-500 mt-2">Layanan terbaik untuk pengalaman berkebun Anda</p>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                <div class="flex flex-col items-center text-center p-6 rounded-2xl hover:bg-green-50 transition duration-300"
                    data-aos="fade-up" data-aos-delay="0">
                    <div
                        class="w-16 h-16 bg-green-100 text-green-600 rounded-full flex items-center justify-center text-2xl mb-4 shadow-sm">
                        <i class="fas fa-seedling"></i>
                    </div>
                    <h3 class="font-bold text-lg text-gray-900">Tanaman Segar</h3>
                    <p class="text-gray-500 text-sm mt-2 leading-relaxed">Kami memastikan setiap tanaman dikirim dalam
                        kondisi segar dan sehat dari kebun.</p>
                </div>
                <div class="flex flex-col items-center text-center p-6 rounded-2xl hover:bg-green-50 transition duration-300"
                    data-aos="fade-up" data-aos-delay="100">
                    <div
                        class="w-16 h-16 bg-green-100 text-green-600 rounded-full flex items-center justify-center text-2xl mb-4 shadow-sm">
                        <i class="fas fa-box-open"></i>
                    </div>
                    <h3 class="font-bold text-lg text-gray-900">Pengiriman Aman</h3>
                    <p class="text-gray-500 text-sm mt-2 leading-relaxed">Packing khusus berlapis yang menjamin tanaman
                        aman dari guncangan.</p>
                </div>
                <div class="flex flex-col items-center text-center p-6 rounded-2xl hover:bg-green-50 transition duration-300"
                    data-aos="fade-up" data-aos-delay="200">
                    <div
                        class="w-16 h-16 bg-green-100 text-green-600 rounded-full flex items-center justify-center text-2xl mb-4 shadow-sm">
                        <i class="fas fa-headset"></i>
                    </div>
                    <h3 class="font-bold text-lg text-gray-900">Support 24/7</h3>
                    <p class="text-gray-500 text-sm mt-2 leading-relaxed">Tim ahli kami siap membantu konsultasi
                        perawatan tanaman Anda.</p>
                </div>
            </div>
        </div>
    </div>

    <section class="py-12">
        <div class="container mx-auto px-4">
            <h2 class="text-3xl font-bold text-center text-gray-900 mb-10">Kategori</h2>

            <div class="grid grid-cols-2 md:grid-cols-4 gap-6">
                <?php 
                $cat_img = [
                    'assets/images/indoor.jpeg', // Indoor
                    'assets/images/outdoor.jpeg', // Outdoor
                    'assets/images/sukulen.jpeg', // Sukulen
                    'assets/images/aksesoris.jpeg'  // Aksesoris
                ];
                $i = 0;
                if ($categories->num_rows > 0): 
                    while($cat = $categories->fetch_assoc()): 
                ?>
                <a href="produk.php?kategori=<?php echo $cat['id_kategori']; ?>"
                    class="group relative rounded-2xl overflow-hidden aspect-[3/4] shadow-md hover:shadow-xl transition duration-300">
                    <div class="absolute inset-0 bg-black/20 group-hover:bg-black/40 transition duration-300 z-10">
                    </div>
                    <img src="<?php echo $cat_img[$i % 4]; ?>" alt="Category"
                        class="absolute inset-0 w-full h-full object-cover transform group-hover:scale-110 transition duration-500">
                    <div class="absolute bottom-0 left-0 w-full p-6 z-20 text-center">
                        <h3 class="text-white font-bold text-xl tracking-wide">
                            <?php echo htmlspecialchars($cat['nama_kategori']); ?></h3>
                        <span
                            class="text-green-200 text-sm opacity-0 group-hover:opacity-100 transition duration-300 transform translate-y-2 group-hover:translate-y-0 block mt-1">Lihat
                            Koleksi &rarr;</span>
                    </div>
                </a>
                <?php 
                    $i++; endwhile; 
                endif; 
                ?>
            </div>
        </div>
    </section>

    <section id="featured" class="py-16 bg-gray-50">
        <div class="container mx-auto px-4">
            <div class="flex justify-between items-end mb-10">
                <div>
                    <h2 class="text-3xl font-bold text-gray-900">Best Selling Plants</h2>
                    <p class="text-gray-500 mt-1">Tanaman paling diminati</p>
                </div>
                <a href="produk.php"
                    class="hidden md:flex items-center gap-2 px-6 py-2 bg-white border border-gray-200 rounded-full text-sm font-semibold hover:bg-green-600 hover:text-white hover:border-green-600 transition duration-300">
                    Lihat Semua <i class="fas fa-arrow-right"></i>
                </a>
            </div>

            <div class="grid grid-cols-2 sm:grid-cols-2 md:grid-cols-4 gap-8">
                <?php if ($featured_products->num_rows > 0): ?>
                <?php while($product = $featured_products->fetch_assoc()): ?>
                <div
                    class="bg-white rounded-2xl shadow-sm hover:shadow-xl transition duration-300 flex flex-col group overflow-hidden border border-gray-100">
                    <div class="relative h-64 bg-gray-100 overflow-hidden">
                        <a href="detail.php?id=<?php echo $product['id_produk']; ?>">
                            <img src="/Plantify/uploads/produk/<?php echo htmlspecialchars($product['gambar']); ?>"
                                alt="<?php echo htmlspecialchars($product['nama_produk']); ?>"
                                class="w-full h-full object-cover transform group-hover:scale-105 transition duration-500"
                                onerror="this.src='https://via.placeholder.com/400x400?text=No+Image'">
                        </a>
                        <button
                            class="absolute bottom-4 right-4 w-10 h-10 bg-white rounded-full shadow-lg text-gray-800 flex items-center justify-center hover:bg-green-600 hover:text-white transition duration-300 transform translate-y-12 opacity-0 group-hover:translate-y-0 group-hover:opacity-100">
                            <i class="fas fa-shopping-bag"></i>
                        </button>
                    </div>

                    <div class="p-5 flex flex-col flex-grow">
                        <div class="text-xs text-green-600 font-bold uppercase tracking-wider mb-1">
                            <?php echo htmlspecialchars($product['nama_kategori']); ?>
                        </div>
                        <h3 class="text-lg font-bold text-gray-900 mb-2 truncate">
                            <a href="detail.php?id=<?php echo $product['id_produk']; ?>"
                                class="hover:text-green-600 transition">
                                <?php echo htmlspecialchars($product['nama_produk']); ?>
                            </a>
                        </h3>
                        <div class="mt-auto flex items-center justify-between">
                            <span class="text-lg font-semibold text-gray-900">
                                Rp <?php echo number_format($product['harga'], 0, ',', '.'); ?>
                            </span>
                        </div>
                    </div>
                </div>
                <?php endwhile; ?>
                <?php endif; ?>
            </div>

            <div class="mt-8 text-center md:hidden">
                <a href="produk.php"
                    class="inline-block px-6 py-3 bg-green-600 text-white rounded-full font-bold shadow-lg hover:bg-green-700 transition">
                    Lihat Semua Produk
                </a>
            </div>
        </div>
    </section>

    <section class="py-16 bg-white border-t border-gray-100">
        <div class="container mx-auto px-4">
            <h2 class="text-3xl font-bold text-gray-900 mb-10">Apa yang mereka katakan tentang <br><span
                    class="text-green-700">Plantify?</span></h2>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                <div class="bg-green-50/50 p-8 rounded-2xl relative">
                    <div class="text-green-300 text-6xl absolute top-4 left-6 opacity-50">"</div>
                    <p class="text-gray-600 italic relative z-10 mb-6 pt-4">
                        "Saya sangat suka dengan pelayanan Plantify. Tanaman sampai dengan selamat, daunnya segar, dan
                        packingnya sangat aman. Ruang tamu saya jadi lebih hidup!"
                    </p>
                    <div class="flex items-center gap-4">
                        <img src="assets/images/dilan.jpeg" alt="User" class="w-12 h-12 rounded-full object-cover">
                        <div>
                            <h4 class="font-bold text-gray-900">Abdul Dilan</h4>
                            <div class="text-yellow-400 text-xs">
                                <i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i
                                    class="fas fa-star"></i><i class="fas fa-star"></i>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="bg-green-50/50 p-8 rounded-2xl relative">
                    <div class="text-green-300 text-6xl absolute top-4 left-6 opacity-50">"</div>
                    <p class="text-gray-600 italic relative z-10 mb-6 pt-4">
                        "Awalnya ragu beli tanaman online, tapi Plantify membuktikan kualitasnya. Garansi hidupnya
                        beneran ada, dan konsultasinya ramah banget. Recomended!"
                    </p>
                    <div class="flex items-center gap-4">
                        <img src="assets/images/ArielNoah.jpeg" alt="User" class="w-12 h-12 rounded-full object-cover">
                        <div>
                            <h4 class="font-bold text-gray-900">Ariel Noah</h4>
                            <div class="text-yellow-400 text-xs">
                                <i class="fas fa-star"></i><i class="fas fa-star"></i><i class="fas fa-star"></i><i
                                    class="fas fa-star"></i><i class="fas fa-star-half-alt"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php include 'includes/footer.php';?>

</body>