<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
$base_url = "/Plantify/";

// Helper count cart agar tidak error jika file cart.php belum di-include sebelumnya
if (!function_exists('countCartItems')) {
    function countCartItems() { 
        return isset($_SESSION['cart']) ? array_sum($_SESSION['cart']) : 0; // Menghitung total item, bukan jenis
    }
}

// Fungsi untuk mendeteksi halaman aktif
function isActive($page) {
    $current_page = basename($_SERVER['PHP_SELF']);
    return $current_page === $page;
}
?>

<link rel="stylesheet" href="../assets/css/navbar.css">

<nav id="navbar"
    class="fixed w-full z-50 top-0 transition-all duration-300 bg-white/95 backdrop-blur-md shadow-sm border-b border-gray-100">
    <div class="container mx-auto px-4 lg:px-8">
        <div class="flex justify-between items-center h-20" id="navbar-inner">

            <a href="<?php echo $base_url; ?>index.php" class="flex items-center gap-2 group z-50 relative">
                <div class="bg-green-100 p-2 rounded-full group-hover:bg-green-600 transition duration-300">
                    <i class="fas fa-leaf text-green-600 text-xl group-hover:text-white transition duration-300"></i>
                </div>
                <span class="text-2xl font-bold text-gray-800 tracking-tight">Plantify<span
                        class="text-green-600">.</span></span>
            </a>

            <div class="hidden md:flex items-center space-x-8">
                <a href="<?php echo $base_url; ?>index.php"
                    class="nav-item <?php echo isActive('index.php') ? 'active' : 'text-gray-600'; ?> hover:text-green-600 font-medium transition">Home</a>
                <a href="<?php echo $base_url; ?>produk.php"
                    class="nav-item <?php echo isActive('produk.php') ? 'active' : 'text-gray-600'; ?> hover:text-green-600 font-medium transition">Produk</a>
                <a href="<?php echo $base_url; ?>cara-merawat.php"
                    class="nav-item <?php echo isActive('cara-merawat.php') ? 'active' : 'text-gray-600'; ?> hover:text-green-600 font-medium transition">Cara
                    Merawat</a>
                <a href="<?php echo $base_url; ?>tentang-kami.php"
                    class="nav-item <?php echo isActive('tentang-kami.php') ? 'active' : 'text-gray-600'; ?> hover:text-green-600 font-medium transition">Tentang
                    Kami</a>
            </div>

            <div class="hidden md:flex items-center gap-4">

                 <?php if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin'): ?>
                <a href="<?php echo $base_url; ?>keranjang.php"
                    class="relative group p-2 rounded-full hover:bg-gray-100 transition">
                    <i class="fas fa-shopping-cart text-gray-600 text-lg group-hover:text-green-600"></i>
                    <?php 
                        $cartCount = countCartItems();
                        if($cartCount > 0): 
                    ?>
                    <span
                        class="absolute top-0 right-0 inline-flex items-center justify-center px-1.5 py-0.5 border-2 border-white text-xs font-bold leading-none text-white transform translate-x-1/4 -translate-y-1/4 bg-red-500 rounded-full">
                        <?php echo $cartCount; ?>
                    </span>
                    <?php endif; ?>
                </a>
                <?php endif; ?>

                <?php if (isset($_SESSION['login']) && $_SESSION['login'] === true): ?>
                <div class="relative group">
                    <button class="flex items-center gap-2 focus:outline-none py-2">
                        <div
                            class="w-9 h-9 rounded-full bg-green-100 border border-green-200 flex items-center justify-center text-green-700 font-bold overflow-hidden">
                            <?php echo strtoupper(substr($_SESSION['username'], 0, 1)); ?>
                        </div>
                        <span
                            class="text-sm font-medium text-gray-700 max-w-[100px] truncate"><?php echo htmlspecialchars($_SESSION['username']); ?></span>
                        <i
                            class="fas fa-chevron-down text-gray-400 text-xs transition-transform group-hover:rotate-180"></i>
                    </button>

                    <div
                        class="absolute right-0 mt-0 w-56 bg-white rounded-xl shadow-xl border border-gray-100 overflow-hidden transform opacity-0 scale-95 group-hover:opacity-100 group-hover:scale-100 transition-all duration-200 origin-top-right invisible group-hover:visible z-50">
                        <div class="px-4 py-3 bg-gray-50 border-b border-gray-100">
                            <p class="text-xs text-gray-500">Hallo,</p>
                            <p class="text-sm font-bold text-gray-800 truncate">
                                <?php echo htmlspecialchars($_SESSION['username']); ?></p>
                        </div>

                        <?php if (isset($_SESSION['role']) && $_SESSION['role'] === 'admin'): ?>
                        <a href="<?php echo $base_url; ?>admin/produk/dashboard.php"
                            class="block px-4 py-2 text-sm text-gray-700 hover:bg-green-50 hover:text-green-600"><i
                                class="fas fa-tachometer-alt w-5"></i> Dashboard</a>
                        <a href="<?php echo $base_url; ?>admin/produk/pesanan.php"
                            class="block px-4 py-2 text-sm text-gray-700 hover:bg-green-50 hover:text-green-600"><i
                                class="fas fa-solid fa-box w-5"></i> Pesanan</a>
                        <?php else: ?>
                        <a href="<?php echo $base_url; ?>profil.php"
                            class="block px-4 py-2 text-sm text-gray-700 hover:bg-green-50 hover:text-green-600"><i
                                class="fas fa-user w-5"></i> Profil</a>
                        <a href="<?php echo $base_url; ?>pesanan_saya.php"
                            class="block px-4 py-2 text-sm text-gray-700 hover:bg-green-50 hover:text-green-600"><i
                                class="fas fa-box w-5"></i> Pesanan Saya</a>
                        <?php endif; ?>

                        <div class="border-t border-gray-100 my-1"></div>
                        <a href="<?php echo $base_url; ?>auth/logout.php"
                            class="block px-4 py-2 text-sm text-red-600 hover:bg-red-50"><i
                                class="fas fa-sign-out-alt w-5"></i> Logout</a>
                    </div>
                </div>
                <?php else: ?>
                <a href="<?php echo $base_url; ?>auth/login.php"
                    class="text-gray-700 font-medium hover:text-green-600 transition">Masuk</a>
                <a href="<?php echo $base_url; ?>auth/register.php"
                    class="bg-green-600 hover:bg-green-700 text-white font-medium px-5 py-2 rounded-full shadow-md hover:shadow-lg transition">Daftar</a>
                <?php endif; ?>
            </div>

            <!-- Mobile Menu Button -->
            <div class="flex items-center gap-4 md:hidden">
                <?php if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin'): ?>
                <a href="<?php echo $base_url; ?>keranjang.php" class="relative p-2 text-gray-700">
                    <i class="fas fa-shopping-cart text-lg"></i>
                    <?php 
                        $cartCount = countCartItems();
                        if($cartCount > 0): 
                    ?>
                    <span
                        class="absolute top-0 right-0 block h-2.5 w-2.5 rounded-full ring-2 ring-white bg-red-500"></span>
                    <?php endif; ?>
                </a>
                <?php endif; ?>

                <button id="mobile-menu-btn"
                    class="text-gray-700 hover:text-green-600 focus:outline-none p-2 relative z-50">
                    <i class="fas fa-bars text-2xl"></i>
                </button>
            </div>
        </div>
    </div>

    <!-- Mobile Menu Overlay -->
    <div id="mobile-menu-overlay" class="fixed inset-0 bg-black/50 hidden opacity-0 transition-opacity duration-300"
        style="z-index: 9998;"></div>

    <!-- Mobile Sidebar -->
    <div id="mobile-sidebar"
        class="fixed top-0 bottom-0 right-0 w-[280px] bg-white transform translate-x-full transition-transform duration-300 ease-in-out shadow-2xl flex flex-col overflow-hidden"
        style="z-index: 9999; max-height: 100vh; height: 100vh;">

        <!-- Header -->
        <div class="p-4 flex justify-between items-center border-b border-gray-100 bg-white flex-shrink-0">
            <span class="text-lg font-bold text-gray-800">Menu</span>
            <button id="close-mobile-menu"
                class="text-gray-500 hover:text-red-500 p-2 rounded-full hover:bg-red-50 transition">
                <i class="fas fa-times text-xl"></i>
            </button>
        </div>

        <!-- Menu Content -->
        <div class="flex-1 overflow-y-auto py-2 px-3 space-y-0.5 bg-white" style="max-height: calc(100vh - 60px);">

            <?php if (isset($_SESSION['login']) && $_SESSION['login'] === true): ?>
            <div class="bg-green-50 rounded-lg p-2.5 mb-1.5 flex items-center gap-2">
                <div
                    class="w-8 h-8 rounded-full bg-green-200 flex items-center justify-center text-green-700 font-bold flex-shrink-0 text-sm">
                    <?php echo strtoupper(substr($_SESSION['username'], 0, 1)); ?>
                </div>
                <div class="overflow-hidden">
                    <p class="text-[9px] text-green-600 font-semibold leading-tight">Halo,</p>
                    <p class="text-xs font-bold text-gray-800 truncate leading-tight">
                        <?php echo htmlspecialchars($_SESSION['username']); ?></p>
                </div>
            </div>
            <?php endif; ?>

            <a href="<?php echo $base_url; ?>index.php"
                class="flex items-center gap-2 px-3 py-1.5 rounded-lg font-medium transition text-sm <?php echo isActive('index.php') ? 'bg-green-50 text-green-600' : 'text-gray-700 hover:bg-green-50 hover:text-green-600'; ?>">
                <i class="fas fa-home w-4 text-center text-xs"></i> Home
            </a>
            <a href="<?php echo $base_url; ?>produk.php"
                class="flex items-center gap-2 px-3 py-1.5 rounded-lg font-medium transition text-sm <?php echo isActive('produk.php') ? 'bg-green-50 text-green-600' : 'text-gray-700 hover:bg-green-50 hover:text-green-600'; ?>">
                <i class="fas fa-leaf w-4 text-center text-xs"></i> Produk
            </a>
            <a href="<?php echo $base_url; ?>cara-merawat.php"
                class="flex items-center gap-2 px-3 py-1.5 rounded-lg font-medium transition text-sm <?php echo isActive('cara-merawat.php') ? 'bg-green-50 text-green-600' : 'text-gray-700 hover:bg-green-50 hover:text-green-600'; ?>">
                <i class="fas fa-book w-4 text-center text-xs"></i> Cara Merawat
            </a>
            <a href="<?php echo $base_url; ?>tentang-kami.php"
                class="flex items-center gap-2 px-3 py-1.5 rounded-lg font-medium transition text-sm <?php echo isActive('tentang-kami.php') ? 'bg-green-50 text-green-600' : 'text-gray-700 hover:bg-green-50 hover:text-green-600'; ?>">
                <i class="fas fa-info-circle w-4 text-center text-xs"></i> Tentang Kami
            </a>

            <?php if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin'): ?>
            <a href="<?php echo $base_url; ?>keranjang.php"
                class="flex items-center gap-2 px-3 py-1.5 rounded-lg font-medium transition text-sm <?php echo isActive('keranjang.php') ? 'bg-green-50 text-green-600' : 'text-gray-700 hover:bg-green-50 hover:text-green-600'; ?>">
                <i class="fas fa-shopping-cart w-4 text-center text-xs"></i> Keranjang
                <?php if(isset($cartCount) && $cartCount > 0): ?>
                <span
                    class="ml-auto bg-red-500 text-white text-xs font-bold px-1.5 py-0.5 rounded-full"><?php echo $cartCount; ?></span>
                <?php endif; ?>
            </a>
            <?php endif; ?>

            <hr class="border-gray-200 my-1">

            <?php if (isset($_SESSION['login']) && $_SESSION['login'] === true): ?>
            <?php if (isset($_SESSION['role']) && $_SESSION['role'] === 'admin'): ?>
            <a href="<?php echo $base_url; ?>admin/dashboard.php"
                class="flex items-center gap-2 px-3 py-1.5 rounded-lg font-medium transition text-sm <?php echo (strpos($_SERVER['PHP_SELF'], 'admin/dashboard.php') !== false) ? 'bg-green-50 text-green-600' : 'text-gray-700 hover:bg-green-50 hover:text-green-600'; ?>">
                <i class="fas fa-tachometer-alt w-4 text-center text-xs"></i> Dashboard
            </a>
            <?php else: ?>
            <a href="<?php echo $base_url; ?>pesanan_saya.php"
                class="flex items-center gap-2 px-3 py-1.5 rounded-lg font-medium transition text-sm <?php echo isActive('pesanan_saya.php') ? 'bg-green-50 text-green-600' : 'text-gray-700 hover:bg-green-50 hover:text-green-600'; ?>">
                <i class="fas fa-box w-4 text-center text-xs"></i> Pesanan Saya
            </a>
            <a href="<?php echo $base_url; ?>profil.php"
                class="flex items-center gap-2 px-3 py-1.5 rounded-lg font-medium transition text-sm <?php echo isActive('profil.php') ? 'bg-green-50 text-green-600' : 'text-gray-700 hover:bg-green-50 hover:text-green-600'; ?>">
                <i class="fas fa-user w-4 text-center text-xs"></i> Profil Saya
            </a>
            <?php endif; ?>

            <a href="<?php echo $base_url; ?>auth/logout.php"
                class="flex items-center gap-2 px-3 py-1.5 rounded-lg text-red-600 hover:bg-red-50 font-medium transition mt-0.5 text-sm">
                <i class="fas fa-sign-out-alt w-4 text-center text-xs"></i> Logout
            </a>
            <?php else: ?>
            <div class="grid grid-cols-2 gap-2 mt-1.5">
                <a href="<?php echo $base_url; ?>auth/login.php"
                    class="text-center py-1.5 rounded-lg border border-gray-300 text-gray-700 font-medium hover:bg-gray-50 text-sm">Masuk</a>
                <a href="<?php echo $base_url; ?>auth/register.php"
                    class="text-center py-1.5 rounded-lg bg-green-600 text-white font-medium hover:bg-green-700 shadow text-sm">Daftar</a>
            </div>
            <?php endif; ?>

        </div>
    </div>
</nav>

<script type="module" src="../assets/js/navbar.js"></script>