<footer class="bg-gray-900 text-white pt-16 pb-8 border-t border-gray-800">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8 mb-12">
            
            <div class="space-y-4">
                <h3 class="text-2xl font-bold text-emerald-400 tracking-wider">Plantify.</h3>
                <p class="text-gray-400 text-sm leading-relaxed">
                    Menghadirkan kesegaran alam ke dalam rumah Anda. Temukan koleksi tanaman hias terbaik yang dikurasi dengan cinta dan keahlian.
                </p>
                <div class="flex space-x-4 pt-2">
                <a href="#" class="hover:text-pink-500 transition"><i class="fab fa-instagram text-xl"></i></a>
                <a href="#" class="hover:text-emerald-400 transition"><i class="fab fa-whatsapp text-xl"></i></a>
                <a href="#" class="hover:text-blue-500 transition"><i class="fab fa-facebook text-xl"></i></a>
                </div>
            </div>

            <div>
                <h4 class="text-lg font-semibold text-white mb-4">Navigasi</h4>
                <ul class="space-y-2 text-sm text-gray-400">
                    <li><a href="#" class="hover:text-emerald-400 transition">Beranda</a></li>
                    <li><a href="#" class="hover:text-emerald-400 transition">Katalog Produk</a></li>
                    <li><a href="#" class="hover:text-emerald-400 transition">Tentang Kami</a></li>
                    <li><a href="#" class="hover:text-emerald-400 transition">Blog Tanaman</a></li>
                </ul>
            </div>

            <div>
                <h4 class="text-lg font-semibold text-white mb-4">Bantuan</h4>
                <ul class="space-y-2 text-sm text-gray-400">
                    <li><a href="#" class="hover:text-emerald-400 transition">Cara Perawatan</a></li>
                    <li><a href="#" class="hover:text-emerald-400 transition">Pengiriman</a></li>
                    <li><a href="#" class="hover:text-emerald-400 transition">Kebijakan Privasi</a></li>
                    <li><a href="#" class="hover:text-emerald-400 transition">Hubungi Kami</a></li>
                </ul>
            </div>

            <div>
                <h4 class="text-lg font-semibold text-white mb-4">Newsletter</h4>
                <p class="text-gray-400 text-sm mb-4">Dapatkan tips perawatan tanaman dan promo eksklusif.</p>
                <form class="flex flex-col space-y-2">
                    <input type="email" placeholder="Email Anda..." class="bg-gray-800 text-white px-4 py-2 rounded-lg focus:outline-none focus:ring-2 focus:ring-emerald-500 border border-gray-700 text-sm">
                    <button type="button" class="bg-emerald-600 hover:bg-emerald-700 text-white px-4 py-2 rounded-lg text-sm font-semibold transition duration-300">
                        Berlangganan
                    </button>
                </form>
            </div>
        </div>

        <div class="border-t border-gray-800 pt-8 mt-8 flex flex-col md:flex-row justify-between items-center text-sm text-gray-500">
            <p>&copy; <?php echo date("Y"); ?> Plantify Indonesia. All rights reserved.</p>
            <div class="flex space-x-6 mt-4 md:mt-0">
                <a href="#" class="hover:text-white transition">Syarat & Ketentuan</a>
                <a href="#" class="hover:text-white transition">FAQ</a>
            </div>
        </div>
    </div>
    <script src="https://unpkg.com/aos@next/dist/aos.js"></script>
    <script>
      document.addEventListener('DOMContentLoaded', function() {
            if (typeof AOS !== 'undefined') {
                AOS.init({
                    once: true, 
                    mirror: false,
                    offset: 50,
                    duration: 800,
                });
            }
        });
    </script>
</footer>
</body>
</html>