<?php
session_start();

require_once 'config/koneksi.php';
require_once 'config/cart.php';

$db = new Koneksi();
$conn = $db->getConnection();

$id_produk = $_GET['id'];

// --- Ambil Data Produk Utama (PERBAIKAN: Tambah kondisi is_deleted = 0) ---
$stmt = $conn->prepare("SELECT p.*, k.nama_kategori FROM produk p 
                        JOIN kategori k ON p.id_kategori = k.id_kategori 
                        WHERE p.id_produk = ? AND p.is_deleted = 0");
$stmt->bind_param("i", $id_produk);
$stmt->execute();
$result = $stmt->get_result();
$produk = $result->fetch_assoc();

if (!$produk) {
    die('
    <!DOCTYPE html>
    <html lang="id">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Produk Tidak Ditemukan - Plantify</title>
        <script src="https://cdn.tailwindcss.com"></script>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    </head>
    <body class="bg-gray-50">
        <div class="min-h-screen flex items-center justify-center px-4">
            <div class="text-center">
                <div class="mb-8">
                    <i class="fas fa-exclamation-triangle text-8xl text-yellow-400"></i>
                </div>
                <h1 class="text-6xl font-bold text-gray-300 mb-4">404</h1>
                <p class="text-2xl text-gray-600 mb-2">Produk Tidak Ditemukan</p>
                <p class="text-gray-500 mb-8">Produk yang Anda cari tidak tersedia atau telah dihapus.</p>
                <div class="flex gap-4 justify-center">
                    <a href="index.php" class="bg-emerald-600 text-white px-8 py-3 rounded-lg hover:bg-emerald-700 transition inline-flex items-center gap-2">
                        <i class="fas fa-home"></i> Kembali ke Beranda
                    </a>
                    <a href="produk.php" class="bg-gray-200 text-gray-700 px-8 py-3 rounded-lg hover:bg-gray-300 transition inline-flex items-center gap-2">
                        <i class="fas fa-store"></i> Lihat Semua Produk
                    </a>
                </div>
            </div>
        </div>
    </body>
    </html>');
}

// --- Ambil Rekomendasi Produk (PERBAIKAN: Tambah kondisi is_deleted = 0 dan stok > 0) ---
$stmt_related = $conn->prepare("SELECT * FROM produk 
                                 WHERE id_kategori = ? 
                                 AND id_produk != ? 
                                 AND is_deleted = 0
                                 AND stok > 0
                                 ORDER BY RAND()
                                 LIMIT 4");
$stmt_related->bind_param("ii", $produk['id_kategori'], $id_produk);
$stmt_related->execute();
$related_products = $stmt_related->get_result();

// Jika produk kategori sama kurang dari 4, ambil produk lain
if ($related_products->num_rows < 4) {
    $existing_ids = [$id_produk];
    while($row = $related_products->fetch_assoc()) {
        $existing_ids[] = $row['id_produk'];
    }
    
    $remaining = 4 - count($existing_ids) + 1;
    $placeholders = str_repeat('?,', count($existing_ids) - 1) . '?';
    
    $stmt_more = $conn->prepare("SELECT * FROM produk 
                                  WHERE id_produk NOT IN ($placeholders)
                                  AND is_deleted = 0
                                  AND stok > 0
                                  ORDER BY RAND()
                                  LIMIT ?");
    
    $types = str_repeat('i', count($existing_ids)) . 'i';
    $params = array_merge($existing_ids, [$remaining]);
    $stmt_more->bind_param($types, ...$params);
    $stmt_more->execute();
    $more_products = $stmt_more->get_result();
    
    // Reset pointer dan gabungkan hasil
    $stmt_related->execute();
    $related_products = $stmt_related->get_result();
    $all_related = [];
    while($row = $related_products->fetch_assoc()) {
        $all_related[] = $row;
    }
    while($row = $more_products->fetch_assoc()) {
        $all_related[] = $row;
    }
}

// --- CEK ROLE USER ---
$is_admin = false;
$is_logged_in = isset($_SESSION['login']) && $_SESSION['login'] === true;

if ($is_logged_in && isset($_SESSION['role']) && $_SESSION['role'] === 'admin') {
    $is_admin = true;
}

// --- PROSES TAMBAH KE KERANJANG ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_to_cart'])) {
    $quantity = (int)$_POST['quantity'];
    addToCart($produk['id_produk'], $quantity);
    header("Location: detail.php?id=" . $produk['id_produk'] . "&status=added");
    exit();
}
?>

<head>
]
    <title><?= htmlspecialchars($produk['nama_produk']); ?> - Plantify</title>
    <?php include 'includes/tailwind.php'; ?>
    
</head>
<body class="bg-gray-50 font-sans antialiased mt-20">

    <?php include 'includes/navbar.php'; ?>

    <div class="bg-white border-b border-gray-200">
        <div class="container mx-auto px-4 py-3">
            <div class="flex text-sm text-gray-500">
                <a href="index.php" class="hover:text-emerald-600">Beranda</a>
                <span class="mx-2">/</span>
                <span class="text-gray-400">Kategori</span>
                <span class="mx-2">/</span>
                <a href="produk.php?kategori=<?= $produk['id_kategori'] ?>" class="hover:text-emerald-600"><?= htmlspecialchars($produk['nama_kategori']) ?></a>
                <span class="mx-2">/</span>
                <span class="text-emerald-600 font-medium"><?= htmlspecialchars($produk['nama_produk']) ?></span>
            </div>
        </div>
    </div>

    <?php if (isset($_GET['status']) && $_GET['status'] == 'added'): ?>
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const Toast = Swal.mixin({
                    toast: true,
                    position: 'top-end',
                    showConfirmButton: false,
                    timer: 3000,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.addEventListener('mouseenter', Swal.stopTimer)
                        toast.addEventListener('mouseleave', Swal.resumeTimer)
                    }
                });

                Toast.fire({
                    icon: 'success',
                    title: 'Berhasil ditambahkan ke keranjang'
                });
            });
        </script>
    <?php endif; ?>

    <div class="container mx-auto px-4 py-10">
        <div class="bg-white rounded-3xl shadow-xl overflow-hidden border border-gray-100 mb-16">
            <div class="grid grid-cols-1 md:grid-cols-2">
                
                <div class="p-6 md:p-10 bg-gray-50 flex items-center justify-center relative overflow-hidden group">
                    <?php if (!empty($produk['gambar'])): ?>
                        <div class="relative w-full aspect-square md:aspect-[4/5] rounded-2xl overflow-hidden shadow-sm">
                            <img src="uploads/produk/<?= htmlspecialchars($produk['gambar']); ?>" 
                                 alt="<?= htmlspecialchars($produk['nama_produk']); ?>" 
                                 class="w-full h-full object-cover transform group-hover:scale-110 transition-transform duration-700 ease-in-out">
                            
                            <?php if($produk['stok'] > 0): ?>
                                <span class="absolute top-4 left-4 bg-emerald-500 text-white text-xs font-bold px-3 py-1 rounded-full shadow-lg">
                                    Ready Stock
                                </span>
                            <?php else: ?>
                                <span class="absolute top-4 left-4 bg-red-500 text-white text-xs font-bold px-3 py-1 rounded-full shadow-lg">
                                    Out of Stock
                                </span>
                            <?php endif; ?>
                        </div>
                    <?php else: ?>
                        <div class="w-full aspect-square bg-gray-200 flex flex-col items-center justify-center text-gray-400 rounded-2xl">
                            <i class="fas fa-leaf text-6xl mb-4"></i>
                            <span>No Image Available</span>
                        </div>
                    <?php endif; ?>
                </div>

                <div class="p-8 md:p-12 flex flex-col justify-center">
                    <div data-aos="fade-up">
                        <span class="text-emerald-600 font-bold tracking-wider text-sm uppercase bg-emerald-50 px-3 py-1 rounded-md inline-block mb-3">
                            <?= htmlspecialchars($produk['nama_kategori']); ?>
                        </span>
                        
                        <h1 class="text-4xl md:text-5xl font-bold text-gray-900 mb-4 leading-tight">
                            <?= htmlspecialchars($produk['nama_produk']); ?>
                        </h1>
                        
                        <div class="flex items-end gap-4 mb-6 border-b border-gray-100 pb-6">
                            <span class="text-4xl font-bold text-emerald-600">
                                Rp <?= number_format($produk['harga'], 0, ',', '.'); ?>
                            </span>
                            <span class="text-gray-500 mb-2 text-sm">/ pcs</span>
                        </div>

                        <div class="mb-8">
                            <h3 class="text-lg font-bold text-gray-800 mb-3">Deskripsi Produk</h3>
                            <p class="text-gray-600 leading-relaxed text-base">
                                <?= nl2br(htmlspecialchars($produk['deskripsi'])); ?>
                            </p>
                        </div>
                        
                        <div class="flex items-center gap-4 mb-8">
                            <div class="text-gray-500">
                                <i class="fas fa-box-open mr-2"></i> Stok Tersedia: 
                                <span class="font-bold text-gray-800"><?= $produk['stok']; ?></span>
                            </div>
                        </div>

                        <div class="mt-auto">
                            <?php if ($is_admin): ?>
                                <div class="p-4 bg-gray-50 rounded-xl border border-gray-200">
                                    <p class="text-sm text-gray-500 mb-3 font-semibold">Admin Actions:</p>
                                    <a href="admin/produk/edit.php?id=<?= $produk['id_produk']; ?>" 
                                       class="inline-flex items-center justify-center bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 px-6 rounded-lg w-full transition shadow-lg hover:shadow-blue-200">
                                        <i class="fas fa-edit mr-2"></i> Edit Produk
                                    </a>
                                </div>
                            <?php elseif ($is_logged_in): ?>
                                <?php if ($produk['stok'] > 0): ?>
                                    <form action="detail.php?id=<?= $produk['id_produk']; ?>" method="POST">
                                        <input type="hidden" name="add_to_cart" value="1">
                                        
                                        <div class="flex flex-col md:flex-row gap-4">
                                            <div class="flex items-center border border-gray-300 rounded-xl w-full md:w-auto bg-white">
                                                <button type="button" onclick="decrementQty()" class="px-4 py-3 text-gray-600 hover:text-emerald-600 hover:bg-emerald-50 rounded-l-xl transition">
                                                    <i class="fas fa-minus"></i>
                                                </button>
                                                <input type="number" name="quantity" id="qtyInput" value="1" min="1" max="<?= $produk['stok'] ?>" 
                                                       class="w-16 text-center border-none focus:ring-0 text-lg font-bold text-gray-800 appearance-none" readonly>
                                                <button type="button" onclick="incrementQty()" class="px-4 py-3 text-gray-600 hover:text-emerald-600 hover:bg-emerald-50 rounded-r-xl transition">
                                                    <i class="fas fa-plus"></i>
                                                </button>
                                            </div>

                                            <button type="submit" class="flex-1 bg-emerald-600 hover:bg-emerald-700 text-white font-bold py-3 px-8 rounded-xl shadow-lg shadow-emerald-200 hover:shadow-emerald-300 transform hover:-translate-y-1 transition-all duration-300 flex items-center justify-center gap-2">
                                                <i class="fas fa-shopping-cart"></i>
                                                <span>Tambah Keranjang</span>
                                            </button>
                                        </div>
                                    </form>
                                <?php else: ?>
                                    <button disabled class="w-full bg-gray-300 text-gray-500 font-bold py-4 rounded-xl cursor-not-allowed">
                                        Stok Habis
                                    </button>
                                <?php endif; ?>
                            <?php else: ?>
                                <a href="auth/login.php" class="block w-full text-center bg-gray-900 hover:bg-gray-800 text-white font-bold py-4 rounded-xl shadow-lg hover:shadow-xl transition-all">
                                    Login untuk Membeli
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php if (isset($all_related) ? count($all_related) > 0 : $related_products->num_rows > 0): ?>
        <div class="mb-12">
            <h2 class="text-2xl font-bold text-gray-900 mb-6 flex items-center gap-2">
                <i class="fas fa-star text-yellow-400"></i> Produk Rekomendasi Lainnya
            </h2>
            <div class="grid grid-cols-2 md:grid-cols-4 gap-6">
                <?php 
                $products_to_show = isset($all_related) ? $all_related : $related_products->fetch_all(MYSQLI_ASSOC);
                foreach($products_to_show as $related): 
                ?>
                    <a href="detail.php?id=<?= $related['id_produk'] ?>" class="group bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden hover:shadow-xl hover:-translate-y-2 transition-all duration-300">
                        <div class="relative h-64 overflow-hidden bg-gray-100">
                            <?php if (!empty($related['gambar'])): ?>
                                <img src="uploads/produk/<?= htmlspecialchars($related['gambar']) ?>" 
                                     alt="<?= htmlspecialchars($related['nama_produk']) ?>" 
                                     class="w-full h-full object-contain p-4 group-hover:scale-110 transition-transform duration-500">
                            <?php else: ?>
                                <div class="w-full h-full flex items-center justify-center text-gray-400">
                                    <i class="fas fa-leaf text-4xl"></i>
                                </div>
                            <?php endif; ?>
                            
                            <!-- Badge Stok -->
                            <?php if($related['stok'] > 0 && $related['stok'] <= 5): ?>
                                <span class="absolute top-2 right-2 bg-orange-500 text-white text-xs font-bold px-2 py-1 rounded-full">
                                    Stok: <?= $related['stok'] ?>
                                </span>
                            <?php elseif($related['stok'] > 5): ?>
                                <span class="absolute top-2 right-2 bg-emerald-500 text-white text-xs font-bold px-2 py-1 rounded-full">
                                    Ready
                                </span>
                            <?php endif; ?>
                        </div>
                        <div class="p-4">
                            <h3 class="font-bold text-gray-800 mb-2 line-clamp-2 group-hover:text-emerald-600 transition min-h-[3rem]">
                                <?= htmlspecialchars($related['nama_produk']) ?>
                            </h3>
                            <div class="flex items-center justify-between">
                                <p class="text-emerald-600 font-bold text-lg">
                                    Rp <?= number_format($related['harga'], 0, ',', '.') ?>
                                </p>
                                <span class="text-xs text-gray-400 group-hover:text-emerald-600 transition">
                                    <i class="fas fa-arrow-right"></i>
                                </span>
                            </div>
                        </div>
                    </a>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>
        
        <div class="mt-8 border-t pt-8">
             <a href="javascript:history.back()" class="inline-flex items-center text-gray-500 hover:text-emerald-600 font-medium transition">
                <i class="fas fa-arrow-left mr-2"></i> Kembali
            </a>
        </div>
    </div>

    <script>
        // Init AOS
        if (typeof AOS !== 'undefined') { AOS.init(); }

        const qtyInput = document.getElementById('qtyInput');
        const maxStock = <?= $produk['stok'] ?>;

        function incrementQty() {
            if(qtyInput) {
                let current = parseInt(qtyInput.value);
                if(current < maxStock) qtyInput.value = current + 1;
            }
        }

        function decrementQty() {
            if(qtyInput) {
                let current = parseInt(qtyInput.value);
                if(current > 1) qtyInput.value = current - 1;
            }
        }
    </script>
</body>
</html>