<?php
session_start(); // Baik untuk memulai session di awal

// 1. Validasi request method
if ($_SERVER["REQUEST_METHOD"] !== "POST") {
    header("Location: ../auth/register.php");
    exit();
}

// 2. Ambil dan amankan data dari form
 $username = trim($_POST['username']);
 $email = trim($_POST['email']);
 $password = trim($_POST['password']);

// 3. Validasi input (jika kosong)
if (empty($username) || empty($email) || empty($password)) {
    header("Location: ../auth/register.php?error=empty");
    exit();
}

// 4. Koneksi ke database
require_once 'koneksi.php';
 $koneksi = new koneksi();
 $conn = $koneksi->getConnection();

// 5. Cek apakah email sudah ada (Menggunakan Prepared Statements)
 $stmt_check_email = $conn->prepare("SELECT id_user FROM user WHERE email = ?");
 $stmt_check_email->bind_param("s", $email);
 $stmt_check_email->execute();
 $result = $stmt_check_email->get_result();

if ($result->num_rows > 0) {
    // Email sudah terdaftar, redirect dengan pesan error
    header("Location: ../auth/register.php?error=email_taken");
    exit();
}

// 6. Hash password
 $hashedPassword = password_hash($password, PASSWORD_DEFAULT);
 $role = "user";

// 7. Simpan data user baru ke database (Menggunakan Prepared Statements)
 $stmt_insert_user = $conn->prepare("INSERT INTO user (username, email, password, role) VALUES (?, ?, ?, ?)");
 $stmt_insert_user->bind_param("ssss", $username, $email, $hashedPassword, $role);

if ($stmt_insert_user->execute()) {
    // Jika berhasil, arahkan ke halaman login dengan pesan sukses
    header("Location: ../auth/login.php?success=registered");
    exit();
} else {
    // Jika gagal, arahkan kembali ke register dengan pesan error umum
    header("Location: ../auth/register.php?error=general");
    exit();
}

// 8. Tutup statement dan koneksi
 $stmt_check_email->close();
 $stmt_insert_user->close();
 $conn->close();

?>