<?php
// 1. Pastikan session dimulai di awal
session_start();

// 2. Include file koneksi
require_once 'koneksi.php';

// 3. Validasi: Pastikan request datang dari metode POST
if ($_SERVER["REQUEST_METHOD"] !== "POST") {
    // Jika bukan POST, tidak ada apa-apa untuk diproses. Kembalikan ke login.
    header("Location: ../auth/login.php");
    exit();
}

// 4. Validasi: Pastikan username dan password tidak kosong
if (empty($_POST['username']) || empty($_POST['password'])) {
    header("Location: ../auth/login.php?error=empty");
    exit();
}

// 5. Buat objek koneksi dan ambil koneksinya
 $db = new Koneksi();
 $conn = $db->getConnection();

// 6. Ambil dan amankan input (meskipun sudah aman karena prepared statement, ini adalah praktik baik)
 $username = trim($_POST['username']);
 $password_input = $_POST['password'];

// 7. Jalankan query dengan prepared statement (sudah sempurna)
 $stmt = $conn->prepare("SELECT * FROM user WHERE username = ?");
 $stmt->bind_param("s", $username);
 $stmt->execute();

 $result = $stmt->get_result();

if ($result->num_rows === 1) {
    $user = $result->fetch_assoc();

    if (password_verify($password_input, $user['password'])) {
        // Login berhasil, buat session
        $_SESSION['login']    = true;
        $_SESSION['username'] = $user['username'];
        $_SESSION['role']     = $user['role'];
        $_SESSION['id_user']  = $user['id_user'];

        // Arahkan berdasarkan role
        if ($user['role'] === 'admin') {
            header("Location: ../admin/produk/dashboard.php");
        } else {
            header("Location: ../index.php");
        }
        exit; // exit() tidak perlu tanda kurung, tapi tidak masalah
    } else {
        // Password salah
        header("Location: ../auth/login.php?error=password");
        exit;
    }
} else {
    // Username tidak ditemukan
    header("Location: ../auth/login.php?error=username");
    exit;
}

// 8. Tutup statement dan koneksi
 $stmt->close();
 $conn->close();

?>