<?php

/**
 * Menambahkan produk ke keranjang
 */
function addToCart($product_id, $quantity = 1) {
    if (!isset($_SESSION['cart'])) {
        $_SESSION['cart'] = [];
    }

    // Jika produk sudah ada di keranjang, tambahkan jumlahnya
    if (isset($_SESSION['cart'][$product_id])) {
        $_SESSION['cart'][$product_id] += $quantity;
    } else {
        // Jika belum, tambahkan sebagai item baru
        $_SESSION['cart'][$product_id] = $quantity;
    }
}

/**
 * Menghitung total item di keranjang
 */
function countCartItems() {
    return isset($_SESSION['cart']) ? count($_SESSION['cart']) : 0;
}

/**
 * Menghapus item dari keranjang
 */
function removeFromCart($product_id) {
    if (isset($_SESSION['cart'][$product_id])) {
        unset($_SESSION['cart'][$product_id]);
    }
}

/**
 * Mengosongkan keranjang
 */
function clearCart() {
    unset($_SESSION['cart']);
}
?>