<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once 'config/koneksi.php';
require_once 'config/cart.php';

// Cek login & produk (Logika PHP tetap sama)
if (!isset($_SESSION['id_user'])) {
    header('Location: auth/login.php');
    exit;
}

if (!isset($_POST['selected_products']) || empty($_POST['selected_products'])) {
    header('Location: keranjang.php');
    exit;
}

$db = new Koneksi();
$conn = $db->getConnection();

$id_user = $_SESSION['id_user'];
$sql_user = "SELECT * FROM user WHERE id_user = ?";
$stmt_user = $conn->prepare($sql_user);
$stmt_user->bind_param("i", $id_user);
$stmt_user->execute();
$user = $stmt_user->get_result()->fetch_assoc();

$selected_ids = explode(',', $_POST['selected_products']);
$selected_ids = array_map('intval', $selected_ids);
$cart = $_SESSION['cart'] ?? [];

$checkout_products = [];
$total_harga = 0;

if (!empty($selected_ids)) {
    $ids_placeholder = implode(',', array_fill(0, count($selected_ids), '?'));
    $sql = "SELECT * FROM produk WHERE id_produk IN ($ids_placeholder)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param(str_repeat('i', count($selected_ids)), ...$selected_ids);
    $stmt->execute();
    $result = $stmt->get_result();

    while ($row = $result->fetch_assoc()) {
        if (isset($cart[$row['id_produk']])) {
            $row['qty'] = $cart[$row['id_produk']];
            $row['subtotal'] = $row['harga'] * $row['qty'];
            $total_harga += $row['subtotal'];
            $checkout_products[] = $row;
        }
    }
}

if (empty($checkout_products)) {
    header('Location: keranjang.php');
    exit;
}
?>



<title>Checkout - Plantify</title>
<?php include 'includes/tailwind.php'; ?>

<link rel="stylesheet" href="assets/css/checkout.css">


<?php include 'includes/navbar.php'; ?>

<body class="bg-gray-50 font-sans text-gray-800">

    <div class="bg-white border-b border-gray-200 sticky top-[60px] z-30 mt-20">
        <div class="container mx-auto px-4 py-4">
            <div class="flex items-center justify-center space-x-4 text-sm font-medium">
                <span class="text-gray-400 flex items-center"><i class="fas fa-shopping-cart mr-2"></i> Keranjang</span>
                <span class="text-gray-300">/</span>
                <span class="text-green-600 flex items-center"><i class="fas fa-credit-card mr-2"></i> Checkout</span>
                <span class="text-gray-300">/</span>
                <span class="text-gray-400">Selesai</span>
            </div>
        </div>
    </div>

    <div class="container mx-auto px-4 py-8 max-w-7xl">
        <form action="proses_checkout.php" method="POST" id="checkout-form">
            <div class="grid grid-cols-1 lg:grid-cols-12 gap-8 items-start">

                <div class="lg:col-span-7 xl:col-span-8 space-y-6">

                    <div>
                        <h1 class="text-2xl font-bold text-gray-900">Informasi Pengiriman</h1>
                        <p class="text-gray-500 text-sm mt-1">Mohon isi data dengan benar agar pesanan sampai tujuan.
                        </p>
                    </div>

                    <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6 md:p-8">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">

                            <div class="col-span-2 md:col-span-1">
                                <label class="block text-sm font-semibold text-gray-700 mb-2">Nama Penerima <span
                                        class="text-red-500">*</span></label>
                                <div class="relative">
                                    <span class="absolute inset-y-0 left-0 pl-3 flex items-center text-gray-400"><i
                                            class="far fa-user"></i></span>
                                    <input type="text" name="nama_pemesan" required
                                        value="<?= htmlspecialchars($user['nama'] ?? '') ?>"
                                        class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-green-500 transition-colors"
                                        placeholder="Nama Lengkap">
                                </div>
                            </div>

                            <div class="col-span-2 md:col-span-1">
                                <label class="block text-sm font-semibold text-gray-700 mb-2">No. WhatsApp / Telepon
                                    <span class="text-red-500">*</span></label>
                                <div class="relative">
                                    <span class="absolute inset-y-0 left-0 pl-3 flex items-center text-gray-400"><i
                                            class="fas fa-phone"></i></span>
                                    <input type="tel" name="telepon" required
                                        value="<?= htmlspecialchars($user['telepon'] ?? '') ?>"
                                        class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-green-500 transition-colors"
                                        placeholder="08xxxxxxxxxx">
                                </div>
                            </div>

                            <div class="col-span-2">
                                <label class="block text-sm font-semibold text-gray-700 mb-2">Email <span
                                        class="text-red-500">*</span></label>
                                <div class="relative">
                                    <span class="absolute inset-y-0 left-0 pl-3 flex items-center text-gray-400"><i
                                            class="far fa-envelope"></i></span>
                                    <input type="email" name="email_pemesan" required
                                        value="<?= htmlspecialchars($user['email'] ?? '') ?>"
                                        class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-green-500 transition-colors"
                                        placeholder="email@anda.com">
                                </div>
                            </div>

                            <div class="col-span-2">
                                <label class="block text-sm font-semibold text-gray-700 mb-2">Alamat Lengkap <span
                                        class="text-red-500">*</span></label>
                                <textarea name="alamat_pemesan" required rows="3"
                                    class="w-full p-4 border border-gray-300 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-green-500 transition-colors"
                                    placeholder="Nama jalan, nomor rumah, RT/RW, kelurahan, kecamatan..."><?= htmlspecialchars($user['alamat'] ?? '') ?></textarea>
                            </div>

                            <div class="col-span-2">
                                <label class="block text-sm font-semibold text-gray-700 mb-2">Catatan untuk Penjual
                                    (Opsional)</label>
                                <textarea name="catatan" rows="2"
                                    class="w-full p-4 border border-gray-300 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-green-500 transition-colors"
                                    placeholder="Contoh: Tolong packing kayu, atau titip di pos satpam."></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                        <h2 class="text-lg font-bold text-gray-900 mb-4 flex items-center gap-2">
                            <i class="fas fa-box-open text-green-600"></i> Detail Item
                        </h2>
                        <div class="space-y-4 product-list max-h-[400px] overflow-y-auto pr-2">
                            <?php foreach ($checkout_products as $p): ?>
                            <div
                                class="flex items-start gap-4 p-3 rounded-lg border border-gray-50 hover:bg-gray-50 transition">
                                <div class="w-20 h-20 bg-gray-200 rounded-md overflow-hidden flex-shrink-0">
                                    <?php if (!empty($p['gambar'])): ?>
                                    <img src="uploads/produk/<?= htmlspecialchars($p['gambar']) ?>"
                                        class="w-full h-full object-cover">
                                    <?php else: ?>
                                    <div class="w-full h-full flex items-center justify-center text-gray-400 text-xs">No
                                        Image</div>
                                    <?php endif; ?>
                                </div>
                                <div class="flex-grow">
                                    <h3 class="font-semibold text-gray-800 text-sm md:text-base">
                                        <?= htmlspecialchars($p['nama_produk']) ?></h3>
                                    <p class="text-gray-500 text-xs md:text-sm mt-1">
                                        Rp <?= number_format($p['harga'], 0, ',', '.') ?> <span class="mx-1">x</span>
                                        <?= $p['qty'] ?> pcs
                                    </p>
                                </div>
                                <div class="text-right">
                                    <p class="font-bold text-gray-900 text-sm md:text-base">Rp
                                        <?= number_format($p['subtotal'], 0, ',', '.') ?></p>
                                </div>
                            </div>
                            <input type="hidden" name="produk_ids[]" value="<?= $p['id_produk'] ?>">
                            <input type="hidden" name="produk_qty[]" value="<?= $p['qty'] ?>">
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>

                <div class="lg:col-span-5 xl:col-span-4 lg:sticky lg:top-24">
                    <div class="bg-white rounded-xl shadow-lg border border-gray-100 overflow-hidden">
                        <div class="p-6 bg-gray-50 border-b border-gray-100">
                            <h2 class="text-lg font-bold text-gray-800">Ringkasan Pesanan</h2>
                        </div>

                        <div class="p-6 space-y-4">
                            <div class="flex justify-between text-gray-600">
                                <span>Total Harga (<?= count($checkout_products) ?> item)</span>
                                <span>Rp <?= number_format($total_harga, 0, ',', '.') ?></span>
                            </div>
                            <div class="flex justify-between text-gray-600">
                                <span>Biaya Pengiriman</span>
                                <span class="text-green-600 font-medium">Gratis</span>
                            </div>
                            <div class="border-t border-dashed border-gray-300 pt-4 mt-4">
                                <div class="flex justify-between items-center">
                                    <span class="font-bold text-gray-800 text-lg">Total Bayar</span>
                                    <span class="font-bold text-2xl text-green-600">Rp
                                        <?= number_format($total_harga, 0, ',', '.') ?></span>
                                </div>
                                <p class="text-xs text-gray-400 text-right mt-1">Termasuk pajak jika berlaku</p>
                            </div>
                        </div>

                        <div class="p-6 pt-0">
                            <input type="hidden" name="total_harga" value="<?= $total_harga ?>">

                            <button type="submit"
                                class="w-full bg-green-600 text-white py-4 rounded-xl font-bold text-lg hover:bg-green-700 focus:ring-4 focus:ring-green-200 transition-all shadow-lg hover:shadow-green-500/30 flex justify-center items-center gap-2 group">
                                <span>Buat Pesanan</span>
                                <i class="fas fa-arrow-right group-hover:translate-x-1 transition-transform"></i>
                            </button>

                            <div class="mt-4 text-center">
                                <a href="keranjang.php"
                                    class="text-gray-500 hover:text-gray-800 text-sm font-medium transition">
                                    <i class="fas fa-chevron-left mr-1"></i> Kembali ke Keranjang
                                </a>
                            </div>
                        </div>

                        <div class="bg-blue-50 p-4 border-t border-blue-100 flex gap-3">
                            <i class="fas fa-shield-alt text-blue-500 mt-1"></i>
                            <p class="text-xs text-blue-700 leading-relaxed">
                                Data Anda dilindungi. Pembayaran akan dikonfirmasi manual oleh admin melalui halaman
                                pesanan.
                            </p>
                        </div>
                    </div>
                </div>

            </div>
        </form>
    </div>

    <script type="module" src="assets/js/checkout.js"></script>

</body>

</html>r