<?php
// Cek status session agar tidak error jika navbar sudah start session
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
require_once 'config/koneksi.php';
?>


<head>

    <title>Panduan Merawat Tanaman - Plantify</title>
    <?php include 'includes/tailwind.php'; ?>
    <link rel="stylesheet" href="assets/css/cara-merawat.css">
</head>

<body class="bg-slate-50 font-sans text-slate-700 antialiased">

    <?php include 'includes/navbar.php'; ?>

    <section class="relative bg-emerald-900 text-white py-24 md:py-32 overflow-hidden">
        <div class="absolute inset-0 opacity-10 pointer-events-none">
            <svg width="100%" height="100%">
                <pattern id="leaf-pattern" x="0" y="0" width="40" height="40" patternUnits="userSpaceOnUse">
                    <path d="M20 0C10 0 0 10 0 20C0 30 10 40 20 40C30 40 40 30 40 20C40 10 30 0 20 0Z" fill="white" />
                </pattern>
                <rect width="100%" height="100%" fill="url(#leaf-pattern)" />
            </svg>
        </div>

        <div class="container mx-auto px-4 relative z-10 text-center">
            <span
                class="inline-block py-1 px-3 rounded-full bg-emerald-800 text-emerald-200 text-sm font-semibold mb-4 border border-emerald-700"
                data-aos="fade-down">
                Plantify Care Guide
            </span>
            <h1 class="text-4xl md:text-6xl font-extrabold mb-6 leading-tight" data-aos="fade-up">
                Rahasia Tanaman <br /> <span class="text-emerald-400">Subur & Bahagia</span>
            </h1>
            <p class="text-lg md:text-xl text-emerald-100 max-w-2xl mx-auto font-light leading-relaxed"
                data-aos="fade-up" data-aos-delay="100">
                Merawat tanaman bukan sekadar menyiram. Temukan teknik terbaik dari ahli botani kami agar tanaman Anda
                tumbuh maksimal.
            </p>
        </div>
    </section>

    <main class="py-20 -mt-10 relative z-20">
        <div class="container mx-auto px-4">

            <div class="text-center mb-16" data-aos="fade-up">
                <h2 class="text-3xl font-bold text-slate-900">Dasar Perawatan</h2>
                <div class="h-1 w-20 bg-emerald-500 mx-auto mt-2 rounded-full"></div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">

                <div class="bg-white rounded-2xl p-8 shadow-lg hover:shadow-2xl hover:-translate-y-2 transition-all duration-300 border border-slate-100 group"
                    data-aos="fade-up">
                    <div
                        class="w-16 h-16 bg-blue-50 rounded-2xl flex items-center justify-center mb-6 group-hover:bg-blue-500 transition-colors duration-300">
                        <i class="fas fa-tint text-2xl text-blue-500 group-hover:text-white transition-colors"></i>
                    </div>
                    <h3 class="text-xl font-bold text-slate-900 mb-3">Teknik Penyiraman</h3>
                    <p class="text-slate-500 leading-relaxed text-sm">
                        Jangan asal siram. Kuncinya adalah konsistensi dan drainase. Pastikan tanah bagian atas (2-3 cm)
                        kering sebelum menyiram kembali untuk menghindari pembusukan akar (*root rot*).
                    </p>
                </div>

                <div class="bg-white rounded-2xl p-8 shadow-lg hover:shadow-2xl hover:-translate-y-2 transition-all duration-300 border border-slate-100 group"
                    data-aos="fade-up" data-aos-delay="100">
                    <div
                        class="w-16 h-16 bg-yellow-50 rounded-2xl flex items-center justify-center mb-6 group-hover:bg-yellow-500 transition-colors duration-300">
                        <i class="fas fa-sun text-2xl text-yellow-500 group-hover:text-white transition-colors"></i>
                    </div>
                    <h3 class="text-xl font-bold text-slate-900 mb-3">Pencahayaan Tepat</h3>
                    <p class="text-slate-500 leading-relaxed text-sm">
                        Kenali jenis tanamanmu. *Low light* bukan berarti tanpa cahaya. Putar pot tanaman setiap minggu
                        agar pertumbuhan daun merata dan tidak condong ke satu sisi.
                    </p>
                </div>

                <div class="bg-white rounded-2xl p-8 shadow-lg hover:shadow-2xl hover:-translate-y-2 transition-all duration-300 border border-slate-100 group"
                    data-aos="fade-up" data-aos-delay="200">
                    <div
                        class="w-16 h-16 bg-emerald-50 rounded-2xl flex items-center justify-center mb-6 group-hover:bg-emerald-500 transition-colors duration-300">
                        <i
                            class="fas fa-seedling text-2xl text-emerald-500 group-hover:text-white transition-colors"></i>
                    </div>
                    <h3 class="text-xl font-bold text-slate-900 mb-3">Pemupukan Berkala</h3>
                    <p class="text-slate-500 leading-relaxed text-sm">
                        Tanaman butuh makan. Berikan pupuk NPK seimbang atau pupuk organik cair setiap 2-4 minggu sekali
                        selama masa pertumbuhan aktif (biasanya pagi hari).
                    </p>
                </div>

                <div class="bg-white rounded-2xl p-8 shadow-lg hover:shadow-2xl hover:-translate-y-2 transition-all duration-300 border border-slate-100 group"
                    data-aos="fade-up" data-aos-delay="300">
                    <div
                        class="w-16 h-16 bg-red-50 rounded-2xl flex items-center justify-center mb-6 group-hover:bg-red-500 transition-colors duration-300">
                        <i class="fas fa-cut text-2xl text-red-500 group-hover:text-white transition-colors"></i>
                    </div>
                    <h3 class="text-xl font-bold text-slate-900 mb-3">Pemangkasan (Pruning)</h3>
                    <p class="text-slate-500 leading-relaxed text-sm">
                        Buang daun kuning atau mati segera. Ini mencegah penyebaran penyakit dan memfokuskan energi
                        tanaman untuk menumbuhkan tunas baru yang lebih sehat.
                    </p>
                </div>

                <div class="bg-white rounded-2xl p-8 shadow-lg hover:shadow-2xl hover:-translate-y-2 transition-all duration-300 border border-slate-100 group"
                    data-aos="fade-up" data-aos-delay="400">
                    <div
                        class="w-16 h-16 bg-purple-50 rounded-2xl flex items-center justify-center mb-6 group-hover:bg-purple-500 transition-colors duration-300">
                        <i
                            class="fas fa-layer-group text-2xl text-purple-500 group-hover:text-white transition-colors"></i>
                    </div>
                    <h3 class="text-xl font-bold text-slate-900 mb-3">Ganti Pot (Repotting)</h3>
                    <p class="text-slate-500 leading-relaxed text-sm">
                        Jika akar mulai keluar dari lubang bawah pot, saatnya pindah rumah. Pilih pot yang 2-3 cm lebih
                        besar dari sebelumnya. Jangan terlalu besar agar tanah tidak terlalu lembab.
                    </p>
                </div>

                <div class="bg-white rounded-2xl p-8 shadow-lg hover:shadow-2xl hover:-translate-y-2 transition-all duration-300 border border-slate-100 group"
                    data-aos="fade-up" data-aos-delay="500">
                    <div
                        class="w-16 h-16 bg-orange-50 rounded-2xl flex items-center justify-center mb-6 group-hover:bg-orange-500 transition-colors duration-300">
                        <i class="fas fa-bug text-2xl text-orange-500 group-hover:text-white transition-colors"></i>
                    </div>
                    <h3 class="text-xl font-bold text-slate-900 mb-3">Pengendalian Hama</h3>
                    <p class="text-slate-500 leading-relaxed text-sm">
                        Periksa bawah daun secara rutin. Bersihkan daun dengan lap basah atau minyak neem (neem oil)
                        untuk mencegah kutu putih dan tungau jaring laba-laba.
                    </p>
                </div>

            </div>
        </div>
    </main>

    <section class="bg-emerald-50 py-20">
        <div class="container mx-auto px-4">
            <div class="flex flex-col lg:flex-row items-center gap-12">
                <div class="w-full lg:w-1/2" data-aos="fade-right">
                    <div class="relative rounded-3xl overflow-hidden shadow-2xl">
                        <img src="https://images.unsplash.com/photo-1463320726281-696a485928c7?ixlib=rb-4.0.3&auto=format&fit=crop&w=800&q=80"
                            alt="Merawat Tanaman" class="w-full h-full object-cover">
                        <div class="absolute inset-0 bg-emerald-900/20"></div>
                        <div
                            class="absolute bottom-6 left-6 right-6 bg-white/90 backdrop-blur-md p-6 rounded-xl shadow-lg">
                            <p class="font-bold text-emerald-800 text-lg">"Tanaman juga makhluk hidup, ajak mereka
                                bicara!"</p>
                            <p class="text-sm text-emerald-600 mt-1">- Expert Botanist</p>
                        </div>
                    </div>
                </div>

                <div class="w-full lg:w-1/2 space-y-8" data-aos="fade-left">
                    <h2 class="text-3xl md:text-4xl font-bold text-slate-900">Tips Profesional untuk Pemula</h2>
                    <p class="text-slate-600 text-lg">
                        Seringkali kesalahan kecil membuat tanaman layu. Berikut adalah hal-hal yang sering terlewatkan:
                    </p>

                    <div class="space-y-4">
                        <div class="flex items-start">
                            <div
                                class="flex-shrink-0 w-8 h-8 rounded-full bg-green-100 flex items-center justify-center mt-1 mr-4">
                                <i class="fas fa-check text-green-600 text-sm"></i>
                            </div>
                            <div>
                                <h4 class="font-bold text-slate-800">Gunakan Air Suhu Ruang</h4>
                                <p class="text-slate-500 text-sm mt-1">Air yang terlalu dingin atau panas bisa membuat
                                    akar tanaman kaget (shock).</p>
                            </div>
                        </div>

                        <div class="flex items-start">
                            <div
                                class="flex-shrink-0 w-8 h-8 rounded-full bg-green-100 flex items-center justify-center mt-1 mr-4">
                                <i class="fas fa-check text-green-600 text-sm"></i>
                            </div>
                            <div>
                                <h4 class="font-bold text-slate-800">Drainase Adalah Segalanya</h4>
                                <p class="text-slate-500 text-sm mt-1">Pastikan pot memiliki lubang. Akar yang terendam
                                    air terlalu lama akan membusuk.</p>
                            </div>
                        </div>

                        <div class="flex items-start">
                            <div
                                class="flex-shrink-0 w-8 h-8 rounded-full bg-green-100 flex items-center justify-center mt-1 mr-4">
                                <i class="fas fa-check text-green-600 text-sm"></i>
                            </div>
                            <div>
                                <h4 class="font-bold text-slate-800">Aklimatisasi</h4>
                                <p class="text-slate-500 text-sm mt-1">Saat baru membeli tanaman, biarkan ia beradaptasi
                                    di tempat teduh selama seminggu sebelum dipindah.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="py-20 bg-white">
        <div class="container mx-auto px-4 text-center">
            <div class="max-w-3xl mx-auto bg-slate-900 rounded-3xl p-10 md:p-16 relative overflow-hidden shadow-2xl"
                data-aos="zoom-in">
                <div
                    class="absolute top-0 right-0 -mr-10 -mt-10 w-40 h-40 bg-emerald-500 rounded-full opacity-20 blur-2xl">
                </div>
                <div
                    class="absolute bottom-0 left-0 -ml-10 -mb-10 w-40 h-40 bg-blue-500 rounded-full opacity-20 blur-2xl">
                </div>

                <h2 class="text-3xl font-bold text-white mb-4 relative z-10">Siap Merawat Tanaman Impianmu?</h2>
                <p class="text-slate-400 mb-8 relative z-10">Temukan bibit unggul, pupuk terbaik, dan alat berkebun
                    lengkap di katalog kami.</p>
                <a href="produk.php"
                    class="relative z-10 inline-flex items-center bg-emerald-500 hover:bg-emerald-600 text-white font-bold py-4 px-8 rounded-full transition-all duration-300 transform hover:scale-105 shadow-lg shadow-emerald-500/30">
                    <i class="fas fa-shopping-bag mr-2"></i> Belanja Sekarang
                </a>
            </div>
        </div>
    </section>

    <?php include 'includes/footer.php'; ?>

</body>

</html>