<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Daftar - Plantify</title>
    <?php include '../includes/tailwind.php'; ?>
    <style>
        ::-webkit-scrollbar { width: 8px; }
        ::-webkit-scrollbar-track { background: #f1f1f1; }
        ::-webkit-scrollbar-thumb { background: #10b981; border-radius: 4px; }
    </style>
</head>
<body class="bg-gray-50 font-sans antialiased">

<div class="min-h-screen flex items-center justify-center p-4">
    <div class="bg-white rounded-2xl shadow-2xl overflow-hidden flex max-w-4xl w-full" data-aos="zoom-in" data-aos-duration="800">
        
        <!-- LEFT IMAGE -->
        <div class="hidden md:block md:w-1/2 bg-cover bg-center relative"
            style="background-image: url('../assets/images/register.jpeg');">
            <div class="absolute inset-0 bg-opacity-40 flex flex-col justify-between p-12 text-white">
                <div>
                    <h1 class="text-4xl font-bold mb-2">Plantify.</h1>
                    <p class="text-gray-100">Mulai perjalanan hijau Anda bersama kami.</p>
                </div>
                <div class="text-sm opacity-80 text-black">
                    &copy; 2026 Plantify Official
                </div>
            </div>
        </div>

        <!-- FORM -->
        <div class="w-full md:w-1/2 p-8 md:p-12 flex flex-col justify-center">
            <div class="text-center mb-8">
                <h2 class="text-3xl font-bold text-gray-900">Buat Akun Baru</h2>
                <p class="text-gray-500 mt-2">Silakan lengkapi data untuk mendaftar</p>
            </div>

            <!-- ALERT -->
            <?php if (isset($_GET['error'])): ?>
                <div class="mb-6 bg-red-50 border-l-4 border-red-500 p-4 rounded shadow-sm">
                    <p class="text-sm text-red-700 font-medium">
                        <?php
                            if ($_GET['error'] == 'empty') echo "Semua field wajib diisi!";
                            elseif ($_GET['error'] == 'email_taken') echo "Email sudah digunakan!";
                            else echo "Terjadi kesalahan, silakan coba lagi.";
                        ?>
                    </p>
                </div>
            <?php endif; ?>

            <form action="../config/proses_register.php" method="POST" class="space-y-6">

                <!-- USERNAME -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Username</label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center text-gray-400">
                            <i class="fas fa-user"></i>
                        </div>
                        <input type="text" name="username" required
                            class="w-full pl-10 pr-3 py-3 border border-gray-300 rounded-lg
                            focus:ring-green-500 focus:border-green-500 transition"
                            placeholder="Username">
                    </div>
                </div>

                <!-- EMAIL -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Email</label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center text-gray-400">
                            <i class="fas fa-envelope"></i>
                        </div>
                        <input type="email" name="email" required
                            class="w-full pl-10 pr-3 py-3 border border-gray-300 rounded-lg
                            focus:ring-green-500 focus:border-green-500 transition"
                            placeholder="Email aktif">
                    </div>
                </div>

                <!-- PASSWORD -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Password</label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center text-gray-400">
                            <i class="fas fa-lock"></i>
                        </div>
                        <input type="password" name="password" required
                            class="w-full pl-10 pr-3 py-3 border border-gray-300 rounded-lg
                            focus:ring-green-500 focus:border-green-500 transition"
                            placeholder="••••••••">
                    </div>
                </div>

                <!-- BUTTON -->
                <button type="submit"
                    class="w-full py-3 rounded-lg bg-green-600 text-white font-bold
                    hover:bg-green-700 transition transform hover:-translate-y-1">
                    Daftar Sekarang
                </button>
            </form>

            <div class="mt-8 text-center">
                <p class="text-sm text-gray-600">
                    Sudah punya akun?
                    <a href="login.php" class="font-medium text-green-600 hover:underline">
                        Masuk di sini
                    </a>
                </p>
            </div>
        </div>
    </div>
</div>

<script>
    AOS.init();
</script>
</body>
</html>
