<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Masuk - Plantify</title>
    <?php include '../includes/tailwind.php'; ?>
    <style>
        /* Custom scrollbar untuk kesan modern */
        ::-webkit-scrollbar {
            width: 8px;
        }

        ::-webkit-scrollbar-track {
            background: #f1f1f1;
        }

        ::-webkit-scrollbar-thumb {
            background: #10b981;
            border-radius: 4px;
        }
    </style>
</head>

<body class="bg-gray-50 font-sans antialiased">

    <div class="min-h-screen flex items-center justify-center p-4">
        <div class="bg-white rounded-2xl shadow-2xl overflow-hidden flex max-w-4xl w-full" data-aos="zoom-in"
            data-aos-duration="800">

            <div class="hidden md:block md:w-1/2 bg-cover bg-center relative"
                style="background-image: url('../assets/images/login.jpeg');">
                <div class="absolute inset-0 bg-opacity-40 flex flex-col justify-between p-12 text-white">
                    <div>
                        <h1 class="text-4xl font-bold mb-2 ">Plantify.</h1>
                        <p class="text-gray-100">Bawa kesegaran alam ke dalam ruangan Anda.</p>
                    </div>
                    <div class="text-sm opacity-80">
                        &copy; 2026 Plantify Official
                    </div>
                </div>
            </div>

            <div class="w-full md:w-1/2 p-8 md:p-12 flex flex-col justify-center">
                <div class="text-center mb-8">
                    <h2 class="text-3xl font-bold text-gray-900">Selamat Datang</h2>
                    <p class="text-gray-500 mt-2">Silakan masuk untuk mengelola akun Anda</p>
                </div>

                <?php if (isset($_GET['error'])): ?>
                <div class="mb-6 bg-red-50 border-l-4 border-red-500 p-4 rounded shadow-sm" data-aos="shake">
                    <div class="flex items-center">
                        <div class="flex-shrink-0 text-red-500">
                            <i class="fas fa-exclamation-circle"></i>
                        </div>
                        <div class="ml-3">
                            <p class="text-sm text-red-700 font-medium">
                                <?php
                                    if ($_GET['error'] == 'username') echo "Username tidak ditemukan!";
                                    elseif ($_GET['error'] == 'password') echo "Kata sandi yang Anda masukkan salah!";
                                ?>
                            </p>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <form class="space-y-6" action="../config/proses_login.php" method="POST">
                    <input type="hidden" name="remember" value="true">

                    <div>
                        <label for="username" class="block text-sm font-medium text-gray-700 mb-1">Username</label>
                        <div class="relative rounded-md shadow-sm">
                            <div
                                class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none text-gray-400">
                                <i class="fas fa-user"></i>
                            </div>
                            <input id="username" name="username" type="text" required
                                class="block w-full pl-10 pr-3 py-3 border border-gray-300 rounded-lg focus:ring-green-500 focus:border-green-500 sm:text-sm transition duration-200"
                                placeholder="Masukkan username Anda">
                        </div>
                    </div>

                    <div>
                        <label for="password" class="block text-sm font-medium text-gray-700 mb-1">Password</label>
                        <div class="relative rounded-md shadow-sm">
                            <div
                                class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none text-gray-400">
                                <i class="fas fa-lock"></i>
                            </div>
                            <input id="password" name="password" type="password" required
                                class="block w-full pl-10 pr-3 py-3 border border-gray-300 rounded-lg focus:ring-green-500 focus:border-green-500 sm:text-sm transition duration-200"
                                placeholder="••••••••">
                        </div>
                        <div class="flex justify-end mt-2">
                            <a href="#" onclick="info()"
                                class="text-sm text-green-600 hover:text-green-500 hover:underline">Lupa password?</a>
                        </div>
                    </div>

                    <div>
                        <button type="submit"
                            class="w-full flex justify-center py-3 px-4 border border-transparent rounded-lg shadow-sm text-sm font-bold text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500 transition duration-300 transform hover:-translate-y-1">
                            Masuk Sekarang
                        </button>
                    </div>
                </form>

                <div class="mt-8 text-center">
                    <p class="text-sm text-gray-600">
                        Belum punya akun?
                        <a href="register.php"
                            class="font-medium text-green-600 hover:text-green-500 hover:underline">Daftar disini</a>
                    </p>
                </div>
            </div>
        </div>
    </div>

    <script>
        AOS.init();

        function info() {
            Swal.fire({
                title: 'Informasi',
                html: `
      <p>
        Kalau mau login sebagai <b>Admin</b><br>
        Username: admin<br>
        Password:  123456
      </p>
    `,
                icon: 'info',
                confirmButtonText: 'Mengerti'
            });
        }
    </script>
</body>

</html>