if (typeof AOS !== "undefined") {
  AOS.init({ duration: 800, once: true });
}

// --- SWEETALERT FUNCTIONS ---

// 1. Konfirmasi Proses/Tolak
function confirmAction(btn, status) {
  const form = btn.closest("form");
  const id = form.getAttribute("id").replace("form-", "");
  const inputStatus = document.getElementById("status-input-" + id);

  let title = status === "diproses" ? "Proses Pesanan?" : "Tolak Pesanan?";
  let text =
    status === "diproses"
      ? "Pesanan akan masuk ke status diproses."
      : "Pesanan akan dibatalkan permanen.";
  let color = status === "diproses" ? "#3B82F6" : "#EF4444";

  Swal.fire({
    title: title,
    text: text,
    icon: "question",
    showCancelButton: true,
    confirmButtonColor: color,
    cancelButtonColor: "#6B7280",
    confirmButtonText: "Ya, Lanjutkan!",
  }).then((result) => {
    if (result.isConfirmed) {
      inputStatus.value = status;
      form.submit();
    }
  });
}

// 2. Konfirmasi Selesai
function confirmFinish(id) {
  Swal.fire({
    title: "Selesaikan Pesanan?",
    text: "Pastikan barang sudah diterima pelanggan.",
    icon: "success",
    showCancelButton: true,
    confirmButtonColor: "#10B981",
    cancelButtonColor: "#6B7280",
    confirmButtonText: "Ya, Selesai!",
  }).then((result) => {
    if (result.isConfirmed) {
      document.getElementById("form-selesai-" + id).submit();
    }
  });
}

// 3. Konfirmasi Hapus
function confirmDelete(id) {
  Swal.fire({
    title: "Hapus Riwayat?",
    text: "Data pesanan ini akan dihapus permanen dari database!",
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#EF4444",
    cancelButtonColor: "#6B7280",
    confirmButtonText: "Ya, Hapus!",
  }).then((result) => {
    if (result.isConfirmed) {
      document.getElementById("form-delete-" + id).submit();
    }
  });
}
