document.addEventListener("DOMContentLoaded", () => {
  const mobileBtn = document.getElementById("mobile-menu-btn");
  const closeBtn = document.getElementById("close-mobile-menu");
  const overlay = document.getElementById("mobile-menu-overlay");
  const sidebar = document.getElementById("mobile-sidebar");
  const body = document.body;

  function openMenu() {
    console.log("Opening menu..."); // Debug
    overlay.classList.remove("hidden");
    // Sedikit delay agar transisi opacity berjalan
    setTimeout(() => {
      overlay.classList.remove("opacity-0");
      overlay.classList.add("opacity-100");
      sidebar.classList.remove("translate-x-full");
      sidebar.classList.add("translate-x-0");
    }, 10);
    body.classList.add("menu-open");
  }

  function closeMenu() {
    console.log("Closing menu..."); // Debug
    overlay.classList.remove("opacity-100");
    overlay.classList.add("opacity-0");
    sidebar.classList.remove("translate-x-0");
    sidebar.classList.add("translate-x-full");

    // Tunggu transisi selesai baru hide display
    setTimeout(() => {
      overlay.classList.add("hidden");
      body.classList.remove("menu-open");
    }, 300);
  }

  if (mobileBtn) {
    mobileBtn.addEventListener("click", (e) => {
      e.preventDefault();
      e.stopPropagation();
      openMenu();
    });
  }

  if (closeBtn) {
    closeBtn.addEventListener("click", (e) => {
      e.preventDefault();
      e.stopPropagation();
      closeMenu();
    });
  }

  if (overlay) {
    overlay.addEventListener("click", closeMenu);
  }

  // Navbar Scroll Effect (Mengecil saat discroll)
  const navbar = document.getElementById("navbar");
  const navbarInner = document.getElementById("navbar-inner");

  window.addEventListener("scroll", () => {
    if (window.scrollY > 20) {
      navbar.classList.add("shadow-md");
      navbarInner.classList.remove("h-20");
      navbarInner.classList.add("h-16");
    } else {
      navbar.classList.remove("shadow-md");
      navbarInner.classList.remove("h-16");
      navbarInner.classList.add("h-20");
    }
  });
});
