// Inisialisasi AOS
if (typeof AOS !== "undefined") {
  AOS.init({
    duration: 800,
    once: true,
  });
}

document.addEventListener("DOMContentLoaded", function () {
  const checkboxes = document.querySelectorAll(".product-checkbox");
  const selectedCountEl = document.getElementById("selected-count");
  const subtotalEl = document.getElementById("subtotal-display");
  const totalEl = document.getElementById("total-display");
  const selectedProductsInput = document.getElementById("selected-products");
  const checkoutForm = document.getElementById("checkout-form");
  const cartCountEl = document.getElementById("cart-count");

  function updateTotal() {
    let total = 0;
    let count = 0;
    const selectedIds = [];

    checkboxes.forEach((cb) => {
      if (cb.checked) {
        const price = parseInt(cb.dataset.price);
        const qty = parseInt(cb.dataset.qty);
        const subtotal = price * qty;
        total += subtotal;
        count++;
        selectedIds.push(cb.dataset.id);
      }
    });

    const formattedTotal = new Intl.NumberFormat("id-ID").format(total);
    if (selectedCountEl) selectedCountEl.textContent = count + " Item";
    if (subtotalEl) subtotalEl.textContent = "Rp " + formattedTotal;
    if (totalEl) totalEl.textContent = "Rp " + formattedTotal;
    if (selectedProductsInput)
      selectedProductsInput.value = selectedIds.join(",");
  }

  checkboxes.forEach((cb) => {
    cb.addEventListener("change", updateTotal);
  });

  if (checkoutForm) {
    checkoutForm.addEventListener("submit", function (e) {
      const selectedIds = selectedProductsInput.value;
      if (!selectedIds || selectedIds.split(",").length === 0) {
        e.preventDefault();
        Swal.fire({
          icon: "info",
          title: "Produk belum dipilih",
          text: "Pilih minimal 1 produk untuk melanjutkan checkout.",
          confirmButtonColor: "#16a34a",
        });
      }
    });
  }

  // Handle Remove Item dengan SweetAlert
  document.querySelectorAll(".btn-remove").forEach((btn) => {
    btn.addEventListener("click", function () {
      const productId = this.dataset.id;

      Swal.fire({
        title: "Hapus Produk?",
        text: "Produk akan dihapus dari keranjang.",
        icon: "warning",
        showCancelButton: true,
        confirmButtonText: "Ya, hapus",
        cancelButtonText: "Batal",
        confirmButtonColor: "#dc2626",
        cancelButtonColor: "#9ca3af",
      }).then((result) => {
        if (result.isConfirmed) {
          // Kirim request AJAX untuk hapus item
          fetch("keranjang.php", {
            method: "POST",
            headers: {
              "Content-Type": "application/x-www-form-urlencoded",
              "X-Requested-With": "XMLHttpRequest",
            },
            body: "action=remove_item&id_produk=" + productId,
          })
            .then((response) => response.json())
            .then((data) => {
              if (data.success) {
                // Hapus elemen dari DOM dengan animasi
                const itemElement = document.querySelector(
                  `.cart-item[data-id="${productId}"]`,
                );
                itemElement.style.opacity = "0";
                itemElement.style.transform = "translateX(-20px)";

                setTimeout(() => {
                  itemElement.remove();

                  // Update jumlah item di cart
                  const remainingItems =
                    document.querySelectorAll(".cart-item").length;
                  if (cartCountEl) cartCountEl.textContent = remainingItems;

                  // Jika tidak ada item lagi, reload halaman
                  if (remainingItems === 0) {
                    location.reload();
                  } else {
                    // Update total
                    updateTotal();

                    Swal.fire({
                      icon: "success",
                      title: "Berhasil!",
                      text: "Produk telah dihapus dari keranjang",
                      timer: 1500,
                      showConfirmButton: false,
                    });
                  }
                }, 300);
              }
            })
            .catch((error) => {
              console.error("Error:", error);
              Swal.fire({
                icon: "error",
                title: "Oops...",
                text: "Terjadi kesalahan. Silakan coba lagi.",
              });
            });
        }
      });
    });
  });

  // Handle Increase Quantity
  document.querySelectorAll(".btn-increase").forEach((btn) => {
    btn.addEventListener("click", function () {
      const productId = this.dataset.id;
      const currentQty = parseInt(this.dataset.qty);
      const newQty = currentQty + 1;

      updateQuantity(productId, newQty);
    });
  });

  // Handle Decrease Quantity
  document.querySelectorAll(".btn-decrease").forEach((btn) => {
    btn.addEventListener("click", function () {
      const productId = this.dataset.id;
      const currentQty = parseInt(this.dataset.qty);
      const newQty = currentQty - 1;

      if (newQty < 1) {
        // Jika quantity < 1, tampilkan konfirmasi hapus
        document.querySelector(`.btn-remove[data-id="${productId}"]`).click();
      } else {
        updateQuantity(productId, newQty);
      }
    });
  });

  function updateQuantity(productId, newQty) {
    // Kirim request AJAX untuk update quantity
    fetch("keranjang.php", {
      method: "POST",
      headers: {
        "Content-Type": "application/x-www-form-urlencoded",
        "X-Requested-With": "XMLHttpRequest",
      },
      body: `action=update_qty&id_produk=${productId}&qty=${newQty}`,
    })
      .then((response) => response.json())
      .then((data) => {
        if (data.success) {
          if (data.removed) {
            // Item dihapus karena qty = 0
            location.reload();
          } else {
            // Update tampilan quantity
            const qtyInput = document.querySelector(
              `.qty-input[data-id="${productId}"]`,
            );
            const subtotalEl = document.querySelector(
              `.item-subtotal[data-id="${productId}"]`,
            );
            const checkbox = document.querySelector(
              `.product-checkbox[data-id="${productId}"]`,
            );
            const increaseBtn = document.querySelector(
              `.btn-increase[data-id="${productId}"]`,
            );
            const decreaseBtn = document.querySelector(
              `.btn-decrease[data-id="${productId}"]`,
            );

            if (qtyInput) qtyInput.value = data.qty;
            if (subtotalEl)
              subtotalEl.textContent = "Rp " + data.subtotal_formatted;
            if (checkbox) checkbox.dataset.qty = data.qty;
            if (increaseBtn) increaseBtn.dataset.qty = data.qty;
            if (decreaseBtn) decreaseBtn.dataset.qty = data.qty;

            // Update total
            updateTotal();
          }
        }
      })
      .catch((error) => {
        console.error("Error:", error);
        Swal.fire({
          icon: "error",
          title: "Oops...",
          text: "Terjadi kesalahan. Silakan coba lagi.",
        });
      });
  }

  // Initial calculation
  updateTotal();
});
