// Function to generate PDF
function generatePDF() {
  const { jsPDF } = window.jspdf;
  const doc = new jsPDF();

  // Header dengan logo dan info
  doc.setFillColor(34, 197, 94); // Green color
  doc.rect(0, 0, 210, 40, "F");

  doc.setTextColor(255, 255, 255);
  doc.setFontSize(24);
  doc.setFont(undefined, "bold");
  doc.text("PLANTIFY", 15, 20);

  doc.setFontSize(10);
  doc.setFont(undefined, "normal");
  doc.text("Laporan Data Produk", 15, 28);
  doc.text("Tanggal: " + new Date().toLocaleDateString("id-ID"), 15, 34);

  // Total produk info - GUNAKAN VARIABEL JAVASCRIPT
  doc.setTextColor(255, 255, 255);
  doc.setFontSize(12);
  doc.setFont(undefined, "bold");
  doc.text("Total: " + phpData.totalProduk + " Produk", 150, 25);

  // Ambil data dari tabel
  const tableRows = [];
  const tableElement = document.getElementById("produkTable");
  const rows = tableElement.querySelectorAll("tbody tr[data-nama]");

  let totalNilai = 0;

  rows.forEach((row, index) => {
    const nama = row.getAttribute("data-nama");
    const kategori = row.getAttribute("data-kategori");
    const harga = parseInt(row.getAttribute("data-harga"));
    const stok = parseInt(row.getAttribute("data-stok"));
    const nilai = harga * stok;
    totalNilai += nilai;

    tableRows.push([
      index + 1,
      nama,
      kategori,
      "Rp " + harga.toLocaleString("id-ID"),
      stok,
      "Rp " + nilai.toLocaleString("id-ID"),
    ]);
  });

  // Tambahkan total row
  tableRows.push([
    {
      content: "TOTAL NILAI INVENTARIS",
      colSpan: 5,
      styles: {
        halign: "right",
        fontStyle: "bold",
        fillColor: [243, 244, 246],
      },
    },
    {
      content: "Rp " + totalNilai.toLocaleString("id-ID"),
      styles: { fontStyle: "bold", fillColor: [243, 244, 246] },
    },
  ]);

  // Generate table
  doc.autoTable({
    startY: 45,
    head: [["No", "Nama Produk", "Kategori", "Harga", "Stok", "Nilai Total"]],
    body: tableRows,
    theme: "striped",
    headStyles: {
      fillColor: [34, 197, 94],
      textColor: [255, 255, 255],
      fontStyle: "bold",
      halign: "center",
    },
    bodyStyles: {
      textColor: [31, 41, 55],
      fontSize: 9,
    },
    alternateRowStyles: {
      fillColor: [249, 250, 251],
    },
    columnStyles: {
      0: { halign: "center", cellWidth: 10 },
      1: { cellWidth: 50 },
      2: { cellWidth: 30 },
      3: { halign: "right", cellWidth: 30 },
      4: { halign: "center", cellWidth: 15 },
      5: { halign: "right", cellWidth: 35 },
    },
    margin: { top: 45, left: 10, right: 10 },
    didDrawPage: function (data) {
      // Footer
      const pageCount = doc.internal.getNumberOfPages();
      doc.setFontSize(8);
      doc.setTextColor(128, 128, 128);
      doc.text(
        "Halaman " +
          doc.internal.getCurrentPageInfo().pageNumber +
          " dari " +
          pageCount,
        doc.internal.pageSize.width / 2,
        doc.internal.pageSize.height - 10,
        { align: "center" },
      );

      // Watermark
      doc.setFontSize(40);
      doc.setTextColor(200, 200, 200);
      doc.text(
        "PLANTIFY",
        doc.internal.pageSize.width / 2,
        doc.internal.pageSize.height / 2,
        {
          align: "center",
          angle: 45,
        },
      );
    },
  });

  // Show success message with SweetAlert
  Swal.fire({
    icon: "success",
    title: "PDF Berhasil Dibuat!",
    text: "Laporan produk akan segera diunduh",
    showConfirmButton: false,
    timer: 1500,
  });

  // Save PDF
  const fileName =
    "Laporan_Produk_Plantify_" +
    new Date().toISOString().split("T")[0] +
    ".pdf";
  doc.save(fileName);
}

document.addEventListener("DOMContentLoaded", function () {
  const tombolHapus = document.querySelectorAll(".btn-hapus");

  tombolHapus.forEach((btn) => {
    btn.addEventListener("click", function () {
      const form = this.closest("form");

      Swal.fire({
        title: "Yakin hapus produk?",
        text: "Tindakan ini tidak dapat dibatalkan!",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#dc2626",
        cancelButtonColor: "#6b7280",
        confirmButtonText: "Ya, hapus!",
        cancelButtonText: "Batal",
      }).then((result) => {
        if (result.isConfirmed) {
          form.submit();
        }
      });
    });
  });
});

if (typeof AOS !== "undefined") {
  AOS.init({ once: true, duration: 800 });
}
