document
  .getElementById("checkout-form")
  .addEventListener("submit", function (e) {
    e.preventDefault();

    const nama = document.querySelector('[name="nama_pemesan"]').value.trim();
    const email = document.querySelector('[name="email_pemesan"]').value.trim();
    const alamat = document
      .querySelector('[name="alamat_pemesan"]')
      .value.trim();
    const telepon = document.querySelector('[name="telepon"]').value.trim();

    if (!nama || !email || !alamat || !telepon) {
      Swal.fire({
        icon: "warning",
        title: "Data belum lengkap",
        text: "Mohon lengkapi semua data pengiriman!",
        confirmButtonColor: "#16a34a",
      });
      return;
    }

    const phoneRegex = /^(\+62|62|0)[0-9]{8,13}$/;
    if (!phoneRegex.test(telepon.replace(/\s|-/g, ""))) {
      Swal.fire({
        icon: "error",
        title: "Nomor tidak valid",
        text: "Gunakan format 08xxx atau 628xxx",
        confirmButtonColor: "#dc2626",
      });
      return;
    }

    Swal.fire({
      title: "Konfirmasi Pesanan",
      text: "Pastikan alamat sudah benar. Lanjutkan checkout?",
      icon: "question",
      showCancelButton: true,
      confirmButtonText: "Ya, lanjutkan",
      cancelButtonText: "Batal",
      confirmButtonColor: "#16a34a",
      cancelButtonColor: "#9ca3af",
    }).then((result) => {
      if (result.isConfirmed) {
        e.target.submit();
      }
    });
  });
