<?php
// --- Proteksi Halaman ---
require_once '../../config/koneksi.php';
require_once '../../includes/session_check.php';

// Pastikan hanya admin
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header("Location: ../../index.php");
    exit();
}

$db = new Koneksi();
$conn = $db->getConnection();

// --- Ambil Data Kategori ---
$kategori_result = $conn->query("SELECT * FROM kategori");
?>

<head>

    <title>Tambah Produk - Plantify Admin</title>

    <?php include '../../includes/tailwind.php' ?>

    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
    </style>
</head>

<body class="bg-gray-50 text-gray-800">

    <div class="min-h-screen flex flex-col justify-center py-12 sm:px-6 lg:px-8">

        <div class="sm:mx-auto sm:w-full sm:max-w-3xl">
            <div class="text-center mb-8">
                <h2 class="text-3xl font-extrabold text-emerald-900">Tambah Produk Baru</h2>
                <p class="mt-2 text-sm text-gray-600">Lengkapi informasi di bawah untuk menambahkan tanaman baru.</p>
            </div>

            <div class="bg-white py-8 px-4 shadow-xl sm:rounded-xl sm:px-10 border border-gray-100">
                <form id="formTambah" action="proses_tambah.php" method="POST" enctype="multipart/form-data"
                    class="space-y-6">

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="nama_produk" class="block text-sm font-medium text-gray-700">Nama Produk</label>
                            <div class="mt-1">
                                <input id="nama_produk" name="nama_produk" type="text" required
                                    class="appearance-none block w-full px-3 py-3 border border-gray-300 rounded-lg shadow-sm placeholder-gray-400 focus:outline-none focus:ring-emerald-500 focus:border-emerald-500 sm:text-sm transition duration-200"
                                    placeholder="Contoh: Monstera Deliciosa">
                            </div>
                        </div>

                        <div>
                            <label for="id_kategori" class="block text-sm font-medium text-gray-700">Kategori</label>
                            <div class="mt-1">
                                <select id="id_kategori" name="id_kategori" required
                                    class="block w-full px-3 py-3 border border-gray-300 bg-white rounded-lg shadow-sm focus:outline-none focus:ring-emerald-500 focus:border-emerald-500 sm:text-sm transition duration-200">
                                    <option value="">-- Pilih Kategori --</option>
                                    <?php while($kategori = $kategori_result->fetch_assoc()): ?>
                                    <option value="<?php echo $kategori['id_kategori']; ?>">
                                        <?php echo htmlspecialchars($kategori['nama_kategori']); ?>
                                    </option>
                                    <?php endwhile; ?>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="harga" class="block text-sm font-medium text-gray-700">Harga (Rp)</label>
                            <div class="mt-1 relative rounded-md shadow-sm">
                                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                    <span class="text-gray-500 sm:text-sm">Rp</span>
                                </div>
                                <input type="number" name="harga" id="harga" required
                                    class="focus:ring-emerald-500 focus:border-emerald-500 block w-full pl-10 sm:text-sm border-gray-300 rounded-lg py-3 transition duration-200"
                                    placeholder="0">
                            </div>
                        </div>

                        <div>
                            <label for="stok" class="block text-sm font-medium text-gray-700">Stok Awal</label>
                            <div class="mt-1">
                                <input type="number" name="stok" id="stok" required
                                    class="appearance-none block w-full px-3 py-3 border border-gray-300 rounded-lg shadow-sm placeholder-gray-400 focus:outline-none focus:ring-emerald-500 focus:border-emerald-500 sm:text-sm transition duration-200"
                                    placeholder="Jumlah stok">
                            </div>
                        </div>
                    </div>

                    <div>
                        <label for="deskripsi" class="block text-sm font-medium text-gray-700">Deskripsi Produk</label>
                        <div class="mt-1">
                            <textarea id="deskripsi" name="deskripsi" rows="4"
                                class="appearance-none block w-full px-3 py-3 border border-gray-300 rounded-lg shadow-sm placeholder-gray-400 focus:outline-none focus:ring-emerald-500 focus:border-emerald-500 sm:text-sm transition duration-200"
                                placeholder="Jelaskan detail tanaman..."></textarea>
                        </div>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Foto Produk</label>
                        <div
                            class="flex items-center space-x-6 bg-gray-50 p-4 rounded-lg border border-dashed border-gray-300">
                            <div class="shrink-0">
                                <img id="preview-image"
                                    class="h-24 w-24 object-cover rounded-lg border border-gray-200 hidden" src="#"
                                    alt="Preview Gambar" />
                                <div id="placeholder-image"
                                    class="h-24 w-24 rounded-lg bg-gray-200 flex items-center justify-center text-gray-400">
                                    <svg class="h-8 w-8" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                    </svg>
                                </div>
                            </div>
                            <label class="block">
                                <span class="sr-only">Pilih file foto</span>
                                <input type="file" id="gambar" name="gambar" accept="image/*" onchange="previewFile()"
                                    class="block w-full text-sm text-slate-500
                                    file:mr-4 file:py-2 file:px-4
                                    file:rounded-full file:border-0
                                    file:text-sm file:font-semibold
                                    file:bg-emerald-50 file:text-emerald-700
                                    hover:file:bg-emerald-100
                                    transition duration-200 cursor-pointer
                                " />
                                <p class="mt-1 text-xs text-gray-500">PNG, JPG, GIF up to 2MB</p>
                            </label>
                        </div>
                    </div>

                    <div class="flex items-center justify-end space-x-4 pt-4 border-t border-gray-100">
                        <a href="dashboard.php"
                            class="px-4 py-2 border border-gray-300 shadow-sm text-sm font-medium rounded-lg text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-emerald-500 transition duration-200">
                            Batal
                        </a>
                        <button type="submit"
                            class="inline-flex justify-center px-4 py-2 border border-transparent text-sm font-medium rounded-lg shadow-sm text-white bg-emerald-600 hover:bg-emerald-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-emerald-500 transition duration-200">
                            Simpan Produk
                        </button>
                    </div>

                </form>
            </div>
        </div>
    </div>

    <script type="module" src="../../assets/js/tambah.js"></script>
</body>

</html>