<?php
// --- Proteksi Halaman ---
require_once '../../config/koneksi.php';
require_once '../../includes/session_check.php';

// Cek apakah admin sudah login
if ($_SESSION['role'] !== 'admin') {
    header("Location: ../../index.php");
    exit();
}

// Validasi input POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: pesanan.php');
    exit;
}

// --- BUAT OBJEK KONEKSI ---
$db = new Koneksi();
$conn = $db->getConnection();

try {
    // Ambil data dari form
    $id_transaksi = intval($_POST['id_transaksi']);
    $status_baru = trim($_POST['status']);

    // Validasi status
    $status_valid = ['menunggu', 'diproses', 'selesai', 'dibatalkan'];
    if (!in_array($status_baru, $status_valid)) {
        throw new Exception('Status tidak valid!');
    }

    // Cek apakah transaksi ada
    $sql_check = "SELECT * FROM transaksi WHERE id_transaksi = ?";
    $stmt_check = $conn->prepare($sql_check);
    $stmt_check->bind_param("i", $id_transaksi);
    $stmt_check->execute();
    $transaksi = $stmt_check->get_result()->fetch_assoc();

    if (!$transaksi) {
        throw new Exception('Transaksi tidak ditemukan!');
    }

    // Update status
    $sql_update = "UPDATE transaksi SET status_pesanan = ? WHERE id_transaksi = ?";
    $stmt_update = $conn->prepare($sql_update);
    $stmt_update->bind_param("si", $status_baru, $id_transaksi);

    if (!$stmt_update->execute()) {
        throw new Exception('Gagal mengupdate status: ' . $stmt_update->error);
    }

    // Set success message
    $_SESSION['success_message'] = 'Status pesanan #' . str_pad($id_transaksi, 8, '0', STR_PAD_LEFT) . ' berhasil diubah menjadi ' . strtoupper($status_baru);

    // Redirect kembali ke halaman pesanan dengan filter status lama
    header('Location: pesanan.php?status=' . $transaksi['status_pesanan']);
    exit;

} catch (Exception $e) {
    $_SESSION['error_message'] = 'Gagal mengupdate status: ' . $e->getMessage();
    header('Location: pesanan.php');
    exit;
}
?>