<?php
require_once '../../config/koneksi.php';
require_once '../../includes/session_check.php';
if ($_SESSION['role'] !== 'admin') {
    header("Location: ../../index.php");
    exit();
}

$db = new Koneksi();
$conn = $db->getConnection();

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Ambil data teks
    $nama_produk = $_POST['nama_produk'];
    $id_kategori = $_POST['id_kategori'];
    $harga = $_POST['harga'];
    $stok = $_POST['stok'];
    $deskripsi = $_POST['deskripsi'];

    // --- Proses Gambar ---
    $nama_file_gambar = null; // Default null
    if (isset($_FILES['gambar']) && $_FILES['gambar']['error'] === 0) {
        $file = $_FILES['gambar'];
        $ekstensi_gambar_valid = ['jpg', 'jpeg', 'png', 'gif'];
        $ekstensi_file = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));

        if (in_array($ekstensi_file, $ekstensi_gambar_valid) && $file['size'] < 2048000) { // Max 2MB
            $nama_file_gambar = uniqid('prod-', true) . '.' . $ekstensi_file;
            move_uploaded_file($file['tmp_name'], '../../uploads/produk/' . $nama_file_gambar);
        } else {
            header("Location: tambah.php?status=invalid_image");
            exit();
        }
    }

    // Simpan ke database
    $stmt = $conn->prepare("INSERT INTO produk (nama_produk, id_kategori, harga, stok, deskripsi, gambar) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("siiiss", $nama_produk, $id_kategori, $harga, $stok, $deskripsi, $nama_file_gambar);
    
    if ($stmt->execute()) {
        header("Location: dashboard.php?status=success");
    } else {
        header("Location: tambah.php?status=failed");
    }
    $stmt->close();
}
 $conn->close();
?>