<?php
require_once '../../config/koneksi.php';
require_once '../../includes/session_check.php';
if ($_SESSION['role'] !== 'admin') {
    header("Location: ../../index.php");
    exit();
}

$db = new Koneksi();
$conn = $db->getConnection();

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $id_produk = $_POST['id_produk'];
    $nama_produk = $_POST['nama_produk'];
    $id_kategori = $_POST['id_kategori'];
    $harga = $_POST['harga'];
    $stok = $_POST['stok'];
    $deskripsi = $_POST['deskripsi'];

    // Ambil nama gambar lama
    $stmt_lama = $conn->prepare("SELECT gambar FROM produk WHERE id_produk = ?");
    $stmt_lama->bind_param("i", $id_produk);
    $stmt_lama->execute();
    $gambar_lama = $stmt_lama->get_result()->fetch_assoc()['gambar'];

    // --- Proses Gambar Baru (Jika Ada) ---
    $nama_file_gambar_final = $gambar_lama; // Default pakai gambar lama
    if (isset($_FILES['gambar']) && $_FILES['gambar']['error'] === 0) {
        $file = $_FILES['gambar'];
        $ekstensi_gambar_valid = ['jpg', 'jpeg', 'png', 'gif'];
        $ekstensi_file = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));

        if (in_array($ekstensi_file, $ekstensi_gambar_valid) && $file['size'] < 2048000) {
            $nama_file_gambar_baru = uniqid('prod-', true) . '.' . $ekstensi_file;
            move_uploaded_file($file['tmp_name'], '../../uploads/produk/' . $nama_file_gambar_baru);
            
            // Hapus gambar lama
            if (!empty($gambar_lama) && file_exists('../../uploads/produk/' . $gambar_lama)) {
                unlink('../../uploads/produk/' . $gambar_lama);
            }
            $nama_file_gambar_final = $nama_file_gambar_baru;
        }
    }

    // Update database
    $stmt = $conn->prepare("UPDATE produk SET nama_produk=?, id_kategori=?, harga=?, stok=?, deskripsi=?, gambar=? WHERE id_produk=?");
    $stmt->bind_param("siiissi", $nama_produk, $id_kategori, $harga, $stok, $deskripsi, $nama_file_gambar_final, $id_produk);
    
    if ($stmt->execute()) {
        header("Location: dashboard.php?status=updated");
    } else {
        header("Location: edit.php?id=$id_produk&status=failed");
    }
    $stmt->close();
}
 $conn->close();
?>