<?php
// --- Proteksi Halaman ---
require_once '../../config/koneksi.php';
require_once '../../includes/session_check.php';

// Pastikan hanya admin yang akses
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header("Location: ../../index.php");
    exit();
}

// --- BUAT OBJEK KONEKSI ---
$db = new Koneksi();
$conn = $db->getConnection();

// --- LOGIC HAPUS PESANAN ---
if (isset($_POST['action']) && $_POST['action'] === 'delete' && isset($_POST['id_transaksi'])) {
    $id_del = $_POST['id_transaksi'];
    
    // Cek status dulu agar aman
    $check = $conn->prepare("SELECT status_pesanan FROM transaksi WHERE id_transaksi = ?");
    $check->bind_param("i", $id_del);
    $check->execute();
    $res_check = $check->get_result()->fetch_assoc();

    if ($res_check && ($res_check['status_pesanan'] == 'selesai' || $res_check['status_pesanan'] == 'dibatalkan')) {
        // Hapus detail transaksi dulu (jika tidak cascade)
        $conn->query("DELETE FROM detail_transaksi WHERE id_transaksi = $id_del");
        // Hapus transaksi utama
        $conn->query("DELETE FROM transaksi WHERE id_transaksi = $id_del");
        $_SESSION['swal_icon'] = 'success';
        $_SESSION['swal_title'] = 'Terhapus!';
        $_SESSION['swal_text'] = 'Data pesanan berhasil dihapus permanen.';
    } else {
        $_SESSION['swal_icon'] = 'error';
        $_SESSION['swal_title'] = 'Gagal!';
        $_SESSION['swal_text'] = 'Pesanan tidak bisa dihapus (Status harus Selesai/Batal).';
    }
    // Redirect clean GET
    header("Location: pesanan.php"); 
    exit();
}

// --- Filter & Search Logic ---
$filter_status = $_GET['status'] ?? 'semua';
$search_query = $_GET['search'] ?? '';

// Base Query
$sql = "SELECT t.* FROM transaksi t WHERE 1=1";

// Filter Search (ID Transaksi atau Nama Pemesan)
if (!empty($search_query)) {
    $sql .= " AND (t.id_transaksi LIKE '%$search_query%' OR t.nama_pemesan LIKE '%$search_query%')";
}

// Filter Status
if ($filter_status !== 'semua') {
    $sql .= " AND t.status_pesanan = ?";
}

$sql .= " ORDER BY t.tanggal_pesan DESC";

$stmt = $conn->prepare($sql);
if ($filter_status !== 'semua') {
    $stmt->bind_param("s", $filter_status);
}
$stmt->execute();
$transaksi = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);

// Hitung statistik (untuk card di atas)
$stats = ['semua' => 0, 'menunggu' => 0, 'diproses' => 0, 'selesai' => 0, 'dibatalkan' => 0];
$sql_stats = "SELECT status_pesanan, COUNT(*) as jumlah FROM transaksi GROUP BY status_pesanan";
$result_stats = $conn->query($sql_stats);
while ($row = $result_stats->fetch_assoc()) {
    $stats[$row['status_pesanan']] = $row['jumlah'];
    $stats['semua'] += $row['jumlah'];
}

// Function detail produk
function getDetailProduk($conn, $id_transaksi) {
    $sql = "SELECT dt.*, p.nama_produk, p.gambar FROM detail_transaksi dt JOIN produk p ON dt.id_produk = p.id_produk WHERE dt.id_transaksi = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id_transaksi);
    $stmt->execute();
    return $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
}

// Function badge modern
function getStatusBadge($status) {
    $badges = [
        'menunggu' => '<span class="inline-flex items-center gap-1.5 px-3 py-1.5 rounded-full text-xs font-bold bg-yellow-50 text-yellow-700 border border-yellow-200"><span class="w-2 h-2 rounded-full bg-yellow-500 animate-pulse"></span> Menunggu</span>',
        'diproses' => '<span class="inline-flex items-center gap-1.5 px-3 py-1.5 rounded-full text-xs font-bold bg-blue-50 text-blue-700 border border-blue-200"><i class="fas fa-cog fa-spin text-[10px]"></i> Diproses</span>',
        'selesai' => '<span class="inline-flex items-center gap-1.5 px-3 py-1.5 rounded-full text-xs font-bold bg-green-50 text-green-700 border border-green-200"><i class="fas fa-check text-[10px]"></i> Selesai</span>',
        'dibatalkan' => '<span class="inline-flex items-center gap-1.5 px-3 py-1.5 rounded-full text-xs font-bold bg-red-50 text-red-700 border border-red-200"><i class="fas fa-times text-[10px]"></i> Dibatalkan</span>'
    ];
    return $badges[$status] ?? $status;
}
?>

<head>

    <title>Kelola Pesanan - Admin Plantify</title>
    <?php include '../../includes/tailwind.php'; ?>
</head>

<body class="bg-gray-50/50 font-sans text-gray-800">

    <?php include '../../includes/navbar.php'; ?>

    <div class="container mx-auto px-4 py-8 max-w-6xl mt-20">

        <div class="flex flex-col md:flex-row justify-between items-end md:items-center mb-8 gap-4"
            data-aos="fade-down">
            <div>
                <h1 class="text-3xl font-extrabold text-gray-900">Kelola Pesanan</h1>
                <p class="text-gray-500 mt-1">Pantau arus kas dan status pengiriman barang.</p>
            </div>

            <form action="" method="GET" class="w-full md:w-auto relative group">
                <input type="hidden" name="status" value="<?= htmlspecialchars($filter_status) ?>">
                <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                    <i class="fas fa-search text-gray-400 group-focus-within:text-green-600 transition"></i>
                </div>
                <input type="text" name="search" value="<?= htmlspecialchars($search_query) ?>"
                    placeholder="Cari ID / Nama Pemesan..."
                    class="pl-10 pr-4 py-2.5 bg-white border border-gray-200 rounded-xl focus:ring-2 focus:ring-green-500 focus:border-green-500 w-full md:w-64 shadow-sm transition-all text-sm">
            </form>
        </div>

        <div class="grid grid-cols-2 md:grid-cols-5 gap-4 mb-8" data-aos="fade-up">
            <?php
        $menus = [
            ['id' => 'semua', 'label' => 'Semua', 'icon' => 'fa-list', 'color' => 'gray', 'val' => $stats['semua']],
            ['id' => 'menunggu', 'label' => 'Menunggu', 'icon' => 'fa-clock', 'color' => 'yellow', 'val' => $stats['menunggu']],
            ['id' => 'diproses', 'label' => 'Diproses', 'icon' => 'fa-cogs', 'color' => 'blue', 'val' => $stats['diproses']],
            ['id' => 'selesai', 'label' => 'Selesai', 'icon' => 'fa-check-circle', 'color' => 'green', 'val' => $stats['selesai']],
            ['id' => 'dibatalkan', 'label' => 'Batal', 'icon' => 'fa-times-circle', 'color' => 'red', 'val' => $stats['dibatalkan']]
        ];
        
        foreach($menus as $m): 
            $active = $filter_status === $m['id'];
            $borderClass = $active ? "ring-2 ring-offset-2 ring-{$m['color']}-500 border-{$m['color']}-500" : "border-gray-100 hover:border-{$m['color']}-300";
        ?>
            <a href="?status=<?= $m['id'] ?>&search=<?= $search_query ?>"
                class="bg-white p-4 rounded-xl shadow-sm border <?= $borderClass ?> transition-all duration-200 group relative overflow-hidden">
                <div class="flex justify-between items-start relative z-10">
                    <div>
                        <p class="text-[10px] md:text-xs font-bold text-gray-400 uppercase tracking-wider mb-1">
                            <?= $m['label'] ?></p>
                        <h3
                            class="text-xl md:text-2xl font-bold text-gray-800 group-hover:text-<?= $m['color'] ?>-600 transition">
                            <?= $m['val'] ?></h3>
                    </div>
                    <div class="p-2 bg-<?= $m['color'] ?>-50 rounded-lg text-<?= $m['color'] ?>-500">
                        <i class="fas <?= $m['icon'] ?>"></i>
                    </div>
                </div>
            </a>
            <?php endforeach; ?>
        </div>

        <?php
    if (isset($_SESSION['swal_icon'])) {
        echo "<script>
            Swal.fire({
                icon: '{$_SESSION['swal_icon']}',
                title: '{$_SESSION['swal_title']}',
                text: '{$_SESSION['swal_text']}',
                confirmButtonColor: '#10B981'
            });
        </script>";
        unset($_SESSION['swal_icon']);
        unset($_SESSION['swal_title']);
        unset($_SESSION['swal_text']);
    }
    
    // Alert Standar (jika ada pesan dari proses_update_status.php)
    if (isset($_SESSION['success_message'])) {
        echo "<script>Swal.fire({icon: 'success', title: 'Berhasil', text: '{$_SESSION['success_message']}', timer: 2000, showConfirmButton: false});</script>";
        unset($_SESSION['success_message']);
    }
    ?>

        <div class="space-y-6">
            <?php if (empty($transaksi)): ?>
            <div class="text-center py-16 bg-white rounded-2xl shadow-sm border border-dashed border-gray-300">
                <div class="bg-gray-50 w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-search text-3xl text-gray-400"></i>
                </div>
                <h3 class="text-lg font-bold text-gray-900">Data tidak ditemukan</h3>
                <p class="text-gray-500 text-sm">Tidak ada pesanan yang cocok dengan filter atau pencarian.</p>
                <a href="pesanan.php" class="mt-4 inline-block text-green-600 font-medium hover:underline">Reset Semua
                    Filter</a>
            </div>
            <?php else: ?>
            <?php foreach ($transaksi as $index => $t): ?>
            <?php $detail_produk = getDetailProduk($conn, $t['id_transaksi']); ?>

            <div class="bg-white rounded-2xl shadow-lg border border-gray-100 overflow-hidden transition-all hover:shadow-xl"
                data-aos="fade-up" data-aos-delay="<?= $index * 50 ?>">
                <div
                    class="bg-gray-50/80 px-6 py-4 border-b border-gray-100 flex flex-col md:flex-row justify-between items-start md:items-center gap-4">
                    <div class="flex items-center gap-4">
                        <div class="bg-white p-2 rounded border border-gray-200 shadow-sm text-center min-w-[60px]">
                            <span
                                class="block text-xs text-gray-400 font-bold uppercase"><?= date('M', strtotime($t['tanggal_pesan'])) ?></span>
                            <span
                                class="block text-xl font-bold text-gray-800 leading-none"><?= date('d', strtotime($t['tanggal_pesan'])) ?></span>
                        </div>
                        <div>
                            <div class="flex items-center gap-2">
                                <h2 class="text-lg font-bold text-gray-900">Order
                                    #<?= str_pad($t['id_transaksi'], 6, '0', STR_PAD_LEFT) ?></h2>
                                <span
                                    class="text-xs text-gray-400 bg-gray-200 px-2 py-0.5 rounded-full"><?= date('H:i', strtotime($t['tanggal_pesan'])) ?>
                                    WIB</span>
                            </div>
                            <p class="text-sm text-gray-500 flex items-center gap-1 mt-0.5">
                                <i class="far fa-user"></i> <?= htmlspecialchars($t['nama_pemesan']) ?>
                            </p>
                        </div>
                    </div>
                    <div class="self-start md:self-center">
                        <?= getStatusBadge($t['status_pesanan']) ?>
                    </div>
                </div>

                <div class="p-6">
                    <div class="flex flex-col lg:flex-row gap-8">

                        <div class="flex-1 space-y-4">
                            <h3 class="text-xs font-bold text-gray-400 uppercase tracking-wider border-b pb-2 mb-3">Item
                                Pesanan</h3>
                            <?php foreach ($detail_produk as $dp): ?>
                            <div class="flex gap-4 items-start group">
                                <div
                                    class="w-14 h-14 rounded-lg bg-gray-100 flex-shrink-0 overflow-hidden border border-gray-200">
                                    <?php if (!empty($dp['gambar'])): ?>
                                    <img src="/Plantify/uploads/produk/<?= htmlspecialchars($dp['gambar']) ?>"
                                        class="w-full h-full object-cover">
                                    <?php else: ?>
                                    <div class="w-full h-full flex items-center justify-center text-gray-400"><i
                                            class="fas fa-image"></i></div>
                                    <?php endif; ?>
                                </div>
                                <div class="flex-1">
                                    <p class="font-bold text-gray-800 text-sm">
                                        <?= htmlspecialchars($dp['nama_produk']) ?></p>
                                    <p class="text-xs text-gray-500"><?= $dp['jumlah_produk'] ?> x Rp
                                        <?= number_format($dp['harga_saat_transaksi'], 0, ',', '.') ?></p>
                                </div>
                                <div class="text-right">
                                    <p class="text-sm font-semibold text-gray-700">Rp
                                        <?= number_format($dp['harga_saat_transaksi'] * $dp['jumlah_produk'], 0, ',', '.') ?>
                                    </p>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>

                        <div class="lg:w-1/3 bg-gray-50 p-5 rounded-xl border border-gray-100 h-fit">
                            <div class="text-sm text-gray-600 mb-4 space-y-1">
                                <p class="font-bold text-gray-800 flex items-center gap-2"><i
                                        class="fas fa-map-marker-alt text-red-400"></i> Alamat Pengiriman</p>
                                <p class="leading-relaxed pl-6"><?= nl2br(htmlspecialchars($t['alamat_pemesan'])) ?></p>
                                <p class="pl-6 text-xs text-gray-500 mt-1"><i class="fas fa-phone"></i> No HP:
                                    <?= isset($t['telepon']) ? htmlspecialchars($t['telepon']) : '-' ?></p>
                            </div>

                            <div class="border-t border-gray-200 my-4 pt-4">
                                <div class="flex justify-between items-end">
                                    <span class="text-sm text-gray-500 font-medium">Total Tagihan</span>
                                    <span class="text-2xl font-bold text-green-700">Rp
                                        <?= number_format($t['total_harga'], 0, ',', '.') ?></span>
                                </div>
                            </div>

                            <div class="mt-6 space-y-2">
                                <?php if ($t['status_pesanan'] === 'menunggu'): ?>
                                <form method="POST" action="proses_update_status.php" class="grid grid-cols-2 gap-2"
                                    id="form-<?= $t['id_transaksi'] ?>">
                                    <input type="hidden" name="id_transaksi" value="<?= $t['id_transaksi'] ?>">

                                    <button type="button" onclick="confirmAction(this, 'diproses')"
                                        class="bg-blue-600 hover:bg-blue-700 text-white py-2 rounded-lg text-sm font-semibold shadow-md transition">
                                        <i class="fas fa-sync-alt"></i> Proses
                                    </button>
                                    <button type="button" onclick="confirmAction(this, 'dibatalkan')"
                                        class="bg-white border border-red-200 text-red-600 hover:bg-red-50 py-2 rounded-lg text-sm font-semibold shadow-sm transition">
                                        <i class="fas fa-times"></i> Tolak
                                    </button>

                                    <input type="hidden" name="status" id="status-input-<?= $t['id_transaksi'] ?>">
                                </form>

                                <?php elseif ($t['status_pesanan'] === 'diproses'): ?>
                                <form method="POST" action="proses_update_status.php"
                                    id="form-selesai-<?= $t['id_transaksi'] ?>">
                                    <input type="hidden" name="id_transaksi" value="<?= $t['id_transaksi'] ?>">
                                    <input type="hidden" name="status" value="selesai">
                                    <button type="button" onclick="confirmFinish(<?= $t['id_transaksi'] ?>)"
                                        class="w-full bg-green-600 hover:bg-green-700 text-white py-3 rounded-lg text-sm font-bold shadow-md hover:shadow-lg transition">
                                        <i class="fas fa-check-double"></i> Tandai Selesai
                                    </button>
                                </form>

                                <?php else: ?>
                                <form method="POST" action="" id="form-delete-<?= $t['id_transaksi'] ?>">
                                    <input type="hidden" name="action" value="delete">
                                    <input type="hidden" name="id_transaksi" value="<?= $t['id_transaksi'] ?>">
                                    <button type="button" onclick="confirmDelete(<?= $t['id_transaksi'] ?>)"
                                        class="w-full flex items-center justify-center gap-2 text-red-500 hover:text-white border border-red-200 hover:bg-red-500 py-2 rounded-lg text-sm font-semibold transition duration-300">
                                        <i class="fas fa-trash-alt"></i> Hapus Riwayat Pesanan
                                    </button>
                                </form>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>

    <script type="module" src="../../assets/js/pesanan.js"></script>

</body>

</html>