<?php
// --- Proteksi Halaman ---
require_once '../../config/koneksi.php';
require_once '../../includes/session_check.php';

if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header("Location: ../../index.php");
    exit();
}

$db = new Koneksi();
$conn = $db->getConnection();

// --- Ambil Data Produk ---
if (!isset($_GET['id'])) {
    header("Location: dashboard.php");
    exit();
}

$stmt = $conn->prepare("SELECT * FROM produk WHERE id_produk = ?");
$stmt->bind_param("i", $_GET['id']);
$stmt->execute();
$result = $stmt->get_result();
$produk = $result->fetch_assoc();

if (!$produk) {
    echo "Produk tidak ditemukan.";
    exit();
}

// --- Ambil Data Kategori ---
$kategori_result = $conn->query("SELECT * FROM kategori");
?>

<head>

    <title>Edit Produk - Plantify Admin</title>
    <?php include '../../includes/tailwind.php' ?>

    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
    </style>
</head>

<body class="bg-gray-50 text-gray-800">

    <div class="min-h-screen flex flex-col justify-center py-12 sm:px-6 lg:px-8">

        <div class="sm:mx-auto sm:w-full sm:max-w-3xl">
            <div class="text-center mb-8">
                <h2 class="text-3xl font-extrabold text-emerald-900">Edit Produk</h2>
                <p class="mt-2 text-sm text-gray-600">Memperbarui informasi untuk: <span
                        class="font-semibold"><?php echo htmlspecialchars($produk['nama_produk']); ?></span></p>
            </div>

            <div class="bg-white py-8 px-4 shadow-xl sm:rounded-xl sm:px-10 border border-gray-100">
                <form id="formEdit" action="proses_edit.php" method="POST" enctype="multipart/form-data"
                    class="space-y-6">
                    <input type="hidden" name="id_produk" value="<?php echo $produk['id_produk']; ?>">

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="nama_produk" class="block text-sm font-medium text-gray-700">Nama Produk</label>
                            <input id="nama_produk" name="nama_produk" type="text"
                                value="<?php echo htmlspecialchars($produk['nama_produk']); ?>" required
                                class="mt-1 block w-full px-3 py-3 border border-gray-300 rounded-lg shadow-sm focus:ring-emerald-500 focus:border-emerald-500 sm:text-sm">
                        </div>
                        <div>
                            <label for="id_kategori" class="block text-sm font-medium text-gray-700">Kategori</label>
                            <select id="id_kategori" name="id_kategori" required
                                class="mt-1 block w-full px-3 py-3 border border-gray-300 bg-white rounded-lg shadow-sm focus:ring-emerald-500 focus:border-emerald-500 sm:text-sm">
                                <?php while($kategori = $kategori_result->fetch_assoc()): ?>
                                <option value="<?php echo $kategori['id_kategori']; ?>"
                                    <?php if ($produk['id_kategori'] == $kategori['id_kategori']) echo 'selected'; ?>>
                                    <?php echo htmlspecialchars($kategori['nama_kategori']); ?>
                                </option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="harga" class="block text-sm font-medium text-gray-700">Harga (Rp)</label>
                            <input type="number" name="harga" id="harga" value="<?php echo $produk['harga']; ?>"
                                required
                                class="mt-1 block w-full px-3 py-3 border border-gray-300 rounded-lg shadow-sm focus:ring-emerald-500 focus:border-emerald-500 sm:text-sm">
                        </div>
                        <div>
                            <label for="stok" class="block text-sm font-medium text-gray-700">Stok</label>
                            <input type="number" name="stok" id="stok" value="<?php echo $produk['stok']; ?>" required
                                class="mt-1 block w-full px-3 py-3 border border-gray-300 rounded-lg shadow-sm focus:ring-emerald-500 focus:border-emerald-500 sm:text-sm">
                        </div>
                    </div>

                    <div>
                        <label for="deskripsi" class="block text-sm font-medium text-gray-700">Deskripsi</label>
                        <textarea id="deskripsi" name="deskripsi" rows="4"
                            class="mt-1 block w-full px-3 py-3 border border-gray-300 rounded-lg shadow-sm focus:ring-emerald-500 focus:border-emerald-500 sm:text-sm"><?php echo htmlspecialchars($produk['deskripsi']); ?></textarea>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Gambar Produk</label>
                        <div
                            class="flex items-start space-x-6 bg-gray-50 p-4 rounded-lg border border-dashed border-gray-300">
                            <div class="shrink-0 text-center">
                                <p class="text-xs text-gray-500 mb-2">Preview</p>
                                <?php $gambar_path = "/Plantify/uploads/produk/" . ($produk['gambar'] ?? 'default.jpg'); ?>
                                <img id="preview-image" src="<?php echo htmlspecialchars($gambar_path); ?>" alt="Produk"
                                    class="h-32 w-32 object-cover rounded-lg shadow-md border border-gray-200">
                            </div>

                            <div class="flex-1">
                                <label class="block w-full">
                                    <span class="sr-only">Ganti Gambar</span>
                                    <input type="file" id="gambar_baru" name="gambar" accept="image/*"
                                        onchange="previewFile()" class="block w-full text-sm text-slate-500
                                        file:mr-4 file:py-2 file:px-4
                                        file:rounded-full file:border-0
                                        file:text-sm file:font-semibold
                                        file:bg-emerald-50 file:text-emerald-700
                                        hover:file:bg-emerald-100
                                        transition duration-200 cursor-pointer mb-2
                                    " />
                                </label>
                                <p class="text-xs text-gray-500">Biarkan kosong jika tidak ingin mengubah gambar.</p>
                            </div>
                        </div>
                    </div>

                    <div class="flex items-center justify-end space-x-4 pt-4 border-t border-gray-100">
                        <a href="dashboard.php"
                            class="px-4 py-2 border border-gray-300 shadow-sm text-sm font-medium rounded-lg text-gray-700 bg-white hover:bg-gray-50 transition duration-200">
                            Batal
                        </a>
                        <button type="submit"
                            class="inline-flex justify-center px-4 py-2 border border-transparent text-sm font-medium rounded-lg shadow-sm text-white bg-emerald-600 hover:bg-emerald-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-emerald-500 transition duration-200">
                            Update Produk
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script type="module" src="../../assets/js/edit.js"></script>
</body>