<?php
// --- Proteksi Halaman ---
require_once '../../config/koneksi.php';
require_once '../../includes/session_check.php';
if ($_SESSION['role'] !== 'admin') {
    header("Location: ../../index.php");
    exit();
}

// --- BUAT OBJEK KONEKSI ---
$db = new Koneksi();
$conn = $db->getConnection();

// --- Parameter Pencarian ---
$search = isset($_GET['search']) ? trim($_GET['search']) : '';
$kategori_filter = isset($_GET['kategori']) ? $_GET['kategori'] : '';

// --- Query Dasar ---
$sql = "SELECT p.*, k.nama_kategori FROM produk p 
        JOIN kategori k ON p.id_kategori = k.id_kategori 
        WHERE p.is_deleted = 0";

// --- Tambah Kondisi Pencarian ---
if (!empty($search)) {
    $search_param = "%$search%";
    $sql .= " AND (p.nama_produk LIKE ? OR p.deskripsi LIKE ? OR k.nama_kategori LIKE ?)";
}

// --- Tambah Filter Kategori ---
if (!empty($kategori_filter)) {
    $sql .= " AND p.id_kategori = ?";
}

$sql .= " ORDER BY p.id_produk DESC";

// --- Eksekusi Query dengan Prepared Statement ---
$stmt = $conn->prepare($sql);

if (!empty($search) && !empty($kategori_filter)) {
    $stmt->bind_param("sssi", $search_param, $search_param, $search_param, $kategori_filter);
} elseif (!empty($search)) {
    $stmt->bind_param("sss", $search_param, $search_param, $search_param);
} elseif (!empty($kategori_filter)) {
    $stmt->bind_param("i", $kategori_filter);
}

$stmt->execute();
$result = $stmt->get_result();
$total_produk = $result->num_rows;

// --- Ambil Data Kategori untuk Filter ---
$sql_kategori = "SELECT * FROM kategori ORDER BY nama_kategori ASC";
$result_kategori = $conn->query($sql_kategori);
?>
<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manajemen Produk - Plantify Admin</title>
    <?php include '../../includes/tailwind.php'; ?>
    <link rel="stylesheet" href="../../assets/css/dashboard.css">
    
    <!-- jsPDF Library -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.31/jspdf.plugin.autotable.min.js"></script>
    

</head>

<?php include '../../includes/navbar.php'; ?>
<body class="bg-gray-50 font-sans text-gray-800 antialiased mt-15">
    
    <main class="container mx-auto px-4 py-10 max-w-7xl">
        
        <!-- Header Section -->
        <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-10 gap-4" data-aos="fade-down">
            <div>
                <h1 class="text-3xl font-bold text-gray-900 tracking-tight">Manajemen Produk</h1>
                <p class="text-gray-500 mt-1">Kelola katalog tanaman dan inventaris Anda di sini.</p>
            </div>
            
            <div class="flex items-center gap-3 flex-wrap">
                <div class="bg-white px-4 py-2 rounded-lg shadow-sm border border-gray-100 hidden md:block">
                    <span class="text-xs font-semibold text-gray-500 uppercase tracking-wider">Total Produk</span>
                    <div class="text-xl font-bold text-green-600 text-center"><?php echo $total_produk; ?> Item</div>
                </div>
                
                <!-- Tombol Generate PDF -->
                <button onclick="generatePDF()" 
                   class="btn-pdf inline-flex items-center gap-2 bg-gradient-to-r from-red-500 to-red-600 hover:from-red-600 hover:to-red-700 text-white font-medium py-3 px-6 rounded-xl shadow-lg shadow-red-500/30 transition-all duration-300 transform hover:-translate-y-1 focus:ring-4 focus:ring-red-300">
                    <i class="fas fa-file-pdf"></i>
                    <span>Buat PDF</span>
                </button>
                
                <a href="tambah.php"
                   class="inline-flex items-center gap-2 bg-green-600 hover:bg-green-700 text-white font-medium py-3 px-6 rounded-xl shadow-lg shadow-green-600/30 transition-all duration-300 transform hover:-translate-y-1 focus:ring-4 focus:ring-green-300">
                    <i class="fas fa-plus"></i>
                    <span>Tambah Produk</span>
                </a>
            </div>
        </div>

        <!-- Search & Filter Section -->
        <div class="bg-white rounded-xl shadow-md border border-gray-100 p-6 mb-6" data-aos="fade-up">
            <form method="GET" action="" class="flex flex-col md:flex-row gap-4">
                <!-- Search Input -->
                <div class="flex-1 relative">
                    <div class="absolute inset-y-0 left-0 pl-4 flex items-center pointer-events-none">
                        <i class="fas fa-search text-gray-400"></i>
                    </div>
                    <input type="text" 
                           name="search" 
                           value="<?php echo htmlspecialchars($search); ?>"
                           placeholder="Cari produk, kategori, atau deskripsi..."
                           class="w-full pl-11 pr-4 py-3 border border-gray-200 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-transparent transition">
                </div>

                <!-- Category Filter -->
                <div class="md:w-64">
                    <select name="kategori" 
                            class="w-full px-4 py-3 border border-gray-200 rounded-lg focus:ring-2 focus:ring-green-500 focus:border-transparent transition">
                        <option value="">Semua Kategori</option>
                        <?php while($kat = $result_kategori->fetch_assoc()): ?>
                        <option value="<?php echo $kat['id_kategori']; ?>" 
                                <?php echo ($kategori_filter == $kat['id_kategori']) ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($kat['nama_kategori']); ?>
                        </option>
                        <?php endwhile; ?>
                    </select>
                </div>

                <!-- Buttons -->
                <div class="flex gap-2">
                    <button type="submit" 
                            class="px-6 py-3 bg-green-600 hover:bg-green-700 text-white font-medium rounded-lg transition duration-200 flex items-center gap-2">
                        <i class="fas fa-filter"></i>
                        <span>Filter</span>
                    </button>
                    
                    <?php if (!empty($search) || !empty($kategori_filter)): ?>
                    <a href="dashboard.php" 
                       class="px-6 py-3 bg-gray-100 hover:bg-gray-200 text-gray-700 font-medium rounded-lg transition duration-200 flex items-center gap-2">
                        <i class="fas fa-redo"></i>
                        <span>Reset</span>
                    </a>
                    <?php endif; ?>
                </div>
            </form>

            <!-- Active Filters Display -->
            <?php if (!empty($search) || !empty($kategori_filter)): ?>
            <div class="mt-4 pt-4 border-t border-gray-100">
                <div class="flex flex-wrap items-center gap-2">
                    <span class="text-sm text-gray-500 font-medium">Filter Aktif:</span>
                    
                    <?php if (!empty($search)): ?>
                    <span class="inline-flex items-center gap-1 px-3 py-1 bg-green-50 text-green-700 text-sm rounded-full border border-green-200">
                        <i class="fas fa-search text-xs"></i>
                        "<?php echo htmlspecialchars($search); ?>"
                        <a href="?kategori=<?php echo $kategori_filter; ?>" class="ml-1 hover:text-green-900">
                            <i class="fas fa-times"></i>
                        </a>
                    </span>
                    <?php endif; ?>
                    
                    <?php if (!empty($kategori_filter)): 
                        $stmt_kat_name = $conn->prepare("SELECT nama_kategori FROM kategori WHERE id_kategori = ?");
                        $stmt_kat_name->bind_param("i", $kategori_filter);
                        $stmt_kat_name->execute();
                        $kat_name_result = $stmt_kat_name->get_result();
                        $kat_name = $kat_name_result->fetch_assoc()['nama_kategori'];
                        $stmt_kat_name->close();
                    ?>
                    <span class="inline-flex items-center gap-1 px-3 py-1 bg-blue-50 text-blue-700 text-sm rounded-full border border-blue-200">
                        <i class="fas fa-tag text-xs"></i>
                        <?php echo htmlspecialchars($kat_name); ?>
                        <a href="?search=<?php echo urlencode($search); ?>" class="ml-1 hover:text-blue-900">
                            <i class="fas fa-times"></i>
                        </a>
                    </span>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>
        </div>

        <!-- Table Section -->
        <div class="bg-white rounded-2xl shadow-xl border border-gray-100 overflow-hidden" data-aos="fade-up" data-aos-delay="100">
            <div class="overflow-x-auto custom-scrollbar">
                <table class="min-w-full leading-normal" id="produkTable">
                    <thead>
                        <tr class="bg-gray-50 border-b border-gray-200 text-left">
                            <th class="px-6 py-4 text-xs font-bold text-gray-500 uppercase tracking-wider w-24">Gambar</th>
                            <th class="px-6 py-4 text-xs font-bold text-gray-500 uppercase tracking-wider">Info Produk</th>
                            <th class="px-6 py-4 text-xs font-bold text-gray-500 uppercase tracking-wider">Harga & Stok</th>
                            <th class="px-6 py-4 text-xs font-bold text-gray-500 uppercase tracking-wider w-1/3">Deskripsi Singkat</th>
                            <th class="px-6 py-4 text-xs font-bold text-gray-500 uppercase tracking-wider text-center">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100">
                        <?php if ($result->num_rows > 0): ?>
                        <?php 
                        $result->data_seek(0); // Reset pointer
                        while($row = $result->fetch_assoc()): 
                        ?>
                        <tr class="hover:bg-gray-50 transition duration-150 ease-in-out group" 
                            data-nama="<?php echo htmlspecialchars($row['nama_produk']); ?>"
                            data-kategori="<?php echo htmlspecialchars($row['nama_kategori']); ?>"
                            data-harga="<?php echo $row['harga']; ?>"
                            data-stok="<?php echo $row['stok']; ?>"
                            data-deskripsi="<?php echo htmlspecialchars($row['deskripsi']); ?>">
                            
                            <td class="px-6 py-4">
                                <div class="relative h-16 w-16 rounded-xl overflow-hidden shadow-sm border border-gray-100 group-hover:shadow-md transition">
                                    <?php if (!empty($row['gambar'])): ?>
                                    <img src="/Plantify/uploads/produk/<?php echo htmlspecialchars($row['gambar']); ?>"
                                         alt="<?php echo htmlspecialchars($row['nama_produk']); ?>"
                                         class="h-full w-full object-cover">
                                    <?php else: ?>
                                    <div class="h-full w-full bg-gray-100 flex items-center justify-center text-gray-400">
                                        <i class="fas fa-image text-xl"></i>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </td>

                            <td class="px-6 py-4">
                                <div class="flex flex-col">
                                    <span class="font-bold text-gray-900 text-base mb-1 group-hover:text-green-600 transition">
                                        <?php echo htmlspecialchars($row['nama_produk']); ?>
                                    </span>
                                    <span class="inline-flex w-fit px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-50 text-green-700 border border-green-100">
                                        <i class="fas fa-tag mr-1 mt-0.5"></i> <?php echo htmlspecialchars($row['nama_kategori']); ?>
                                    </span>
                                </div>
                            </td>

                            <td class="px-6 py-4">
                                <div class="flex flex-col gap-1">
                                    <span class="text-sm font-bold text-gray-800">
                                        Rp <?php echo number_format($row['harga'], 0, ',', '.'); ?>
                                    </span>
                                    <span class="text-xs text-gray-500">
                                        Stok: <span class="<?php echo $row['stok'] < 5 ? 'text-red-600 font-bold' : 'text-gray-700 font-medium'; ?>">
                                            <?php echo $row['stok']; ?>
                                        </span> Unit
                                    </span>
                                </div>
                            </td>

                            <td class="px-6 py-4">
                                <p class="text-sm text-gray-600 leading-relaxed line-clamp-2">
                                    <?php echo htmlspecialchars(substr($row['deskripsi'], 0, 100)) . (strlen($row['deskripsi']) > 100 ? '...' : ''); ?>
                                </p>
                            </td>

                            <td class="px-6 py-4 text-center">
                                <div class="flex items-center justify-center gap-2 opacity-80 group-hover:opacity-100 transition">
                                    <a href="edit.php?id=<?php echo $row['id_produk']; ?>"
                                       class="p-2 bg-blue-50 text-blue-600 rounded-lg hover:bg-blue-600 hover:text-white transition duration-200"
                                       title="Edit Produk">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    
                                    <a href="../../detail.php?id=<?php echo $row['id_produk']; ?>"
                                       class="p-2 bg-gray-50 text-gray-600 rounded-lg hover:bg-gray-600 hover:text-white transition duration-200"
                                       title="Lihat Detail">
                                        <i class="fas fa-eye"></i>
                                    </a>

                                    <form action="hapus.php" method="POST" class="inline">
                                        <input type="hidden" name="id_produk" value="<?php echo $row['id_produk']; ?>">
                                        <button type="button"
                                                class="btn-hapus p-2 bg-red-50 text-red-600 rounded-lg hover:bg-red-600 hover:text-white transition duration-200"
                                                title="Hapus Produk">
                                            <i class="fas fa-trash-alt"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                        <?php else: ?>
                        <tr>
                            <td colspan="5" class="px-6 py-16 text-center">
                                <div class="flex flex-col items-center justify-center text-gray-400">
                                    <?php if (!empty($search) || !empty($kategori_filter)): ?>
                                        <i class="fas fa-search text-6xl mb-4 text-gray-200"></i>
                                        <p class="text-lg font-medium text-gray-500">Tidak ada produk ditemukan</p>
                                        <p class="text-sm mb-4">Coba ubah kata kunci atau filter pencarian Anda.</p>
                                        <a href="dashboard.php" class="text-green-600 font-semibold hover:underline">Reset Pencarian</a>
                                    <?php else: ?>
                                        <i class="fas fa-box-open text-6xl mb-4 text-gray-200"></i>
                                        <p class="text-lg font-medium text-gray-500">Belum ada produk</p>
                                        <p class="text-sm mb-4">Mulai dengan menambahkan produk tanaman baru.</p>
                                        <a href="tambah.php" class="text-green-600 font-semibold hover:underline">Tambah Produk Sekarang</a>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            
            <div class="px-6 py-4 bg-gray-50 border-t border-gray-200 flex justify-between items-center">
                <span class="text-xs text-gray-500">
                    Menampilkan <?php echo $total_produk; ?> produk
                    <?php if (!empty($search) || !empty($kategori_filter)): ?>
                        dari hasil pencarian
                    <?php endif; ?>
                </span>
            </div>
        </div>
    </main>
        <script>
        const phpData = {
            totalProduk: <?php echo $total_produk; ?>
        };
    </script>
    <script src="../../assets/js/dashboard.js"></script>

    
    
</body>
</html>